/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.component;

import com.suncode.plugin.datasource.excel.component.OutputParameter;
import com.suncode.plugin.datasource.excel.erasers.SpreadSheetDataEraser;
import com.suncode.plugin.datasource.excel.readers.SpreadsheetDataReader;
import com.suncode.plugin.datasource.excel.updaters.SpreadsheetDataUpdater;
import com.suncode.plugin.datasource.excel.util.AutoCloseableTempFile;
import com.suncode.plugin.datasource.excel.util.ExcelSpringContext;
import com.suncode.plugin.datasource.excel.util.PluginInfo;
import com.suncode.plugin.datasource.excel.writers.SpreadsheetDataWriter;
import com.suncode.plugin.googlecloudintegrator.googledrive.service.GoogleIntegratorService;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExcelDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(ExcelDataSource.class);
    private static final String PLUSWORKFLOW_HOME_TAG = "{PWFL_HOME}";
    private static final String PLUSWORKFLOW_WORKING_DIRECTORY_TAG = "{WORKING_DIRECTORY}";
    private static final String GOOGLE_DRIVE_SOURCE_ID = "googleDrive";
    private final String sourceType;
    private final String googleDriveConfigId;
    private final String pathToFile;
    private final String handleExisting;
    private final String handleNewKey;
    private final Map<String, String> pathParameters;
    private final Map<String, String> inputParameters;
    private final Map<String, OutputParameter> outputParameters;
    private final Translator translator;
    private final Boolean defaultNumericFormat;
    private String googleFileId;
    private String sheetName;

    public ExcelDataSource(Parameters parameters, DataSourceOperation operation, Translator translator) {
        this.sourceType = (String)Optional.ofNullable(parameters.get("sourceType", String.class)).orElse((String)parameters.getRaw("sourceType").getParameter().getDefaultValue());
        this.googleDriveConfigId = (String)Optional.ofNullable(parameters.get("googleDriveConfigId", String.class)).orElse("");
        this.googleFileId = (String)Optional.ofNullable(parameters.get("googleFileId", String.class)).orElse("");
        this.pathToFile = this.buildPathToFile((String)parameters.get("pathToFile", String.class));
        this.sheetName = (String)parameters.get("sheetName", String.class);
        this.handleExisting = (String)parameters.get("handleExisting", String.class);
        this.handleNewKey = (String)parameters.get("handleNewKey", String.class);
        this.pathParameters = this.buildInputParameters((String[])parameters.get("pathParametersId", String[].class), (String[])parameters.get("pathParametersName", String[].class), "Path");
        this.inputParameters = this.buildInputParameters((String[])parameters.get("inputParametersHeader", String[].class), operation == DataSourceOperation.UPDATE ? (String[])parameters.get("inputParametersType", String[].class) : (String[])Stream.generate(() -> "param").limit(((String[])parameters.get("inputParametersHeader", String[].class)).length).toArray(String[]::new), "Input");
        this.outputParameters = this.buildOutputParameters((String[])parameters.get("outputParametersId", String[].class), (String[])parameters.get("outputParametersName", String[].class), (String[])parameters.get("outputParametersHeader", String[].class));
        this.translator = translator;
        this.defaultNumericFormat = (Boolean)parameters.get("defaultNumericFormat", Boolean.class);
    }

    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        LinkedHashMap dataToProcess;
        log.info("Excel DataSources executed with following parameters: " + parameters);
        LinkedHashMap pathParameterValues = this.pathParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, parameter -> (String)parameters.get(parameter.getKey()), (existing, candidate) -> existing, LinkedHashMap::new));
        String resolvedPathToFile = this.includeInputParameters(this.pathToFile, pathParameterValues);
        this.googleFileId = this.includeInputParameters(this.googleFileId, pathParameterValues);
        this.sheetName = this.includeInputParameters(this.sheetName, pathParameterValues);
        if (this.getOperation() != DataSourceOperation.READ) {
            log.info("Resolved path to file: " + resolvedPathToFile);
        }
        Assert.isTrue(((dataToProcess = this.inputParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, parameter -> (String)parameters.get(parameter.getKey()), (existing, candidate) -> existing, LinkedHashMap::new))).values().stream().map(value -> value.split(";", -1).length).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Parameters values are not equal in size!");
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        switch (this.getOperation()) {
            case DELETE: {
                this.deleteData(dataToProcess, resolvedPathToFile);
                return new CountedResult(0L, new ArrayList());
            }
            case INSERT: {
                this.insertData(dataToProcess, resolvedPathToFile);
                return new CountedResult(0L, new ArrayList());
            }
            case READ: {
                return this.readData(filters, pagination, resolvedPathToFile);
            }
            case UPDATE: {
                this.updateFile(dataToProcess, resolvedPathToFile);
                return new CountedResult(0L, new ArrayList());
            }
        }
        throw new UnsupportedOperationException();
    }

    private void deleteData(Map<String, String> parameters, String resolvedPathToFile) throws IOException {
        if (this.sourceType.equals(GOOGLE_DRIVE_SOURCE_ID)) {
            PluginInfo.checkGoogleCloudLicence();
            try (AutoCloseableTempFile tempFile = new AutoCloseableTempFile();){
                resolvedPathToFile = this.downloadFileFromGoogleDrive(tempFile);
                SpreadSheetDataEraser.deleteSheetData(resolvedPathToFile, this.sheetName, parameters, this.translator);
                this.updateFileInGoogleDrive(tempFile.getFile());
            }
        } else {
            SpreadSheetDataEraser.deleteSheetData(resolvedPathToFile, this.sheetName, parameters, this.translator);
        }
    }

    private void updateFile(Map<String, String> parameters, String resolvedPathToFile) throws IOException {
        List<Map<String, String>> primaryKey = this.getPrimaryKey(parameters);
        if (this.sourceType.equals(GOOGLE_DRIVE_SOURCE_ID)) {
            PluginInfo.checkGoogleCloudLicence();
            try (AutoCloseableTempFile tempFile = new AutoCloseableTempFile();){
                resolvedPathToFile = this.downloadFileFromGoogleDrive(tempFile);
                SpreadsheetDataUpdater.updateSheetData(resolvedPathToFile, this.sheetName, primaryKey, this.handleNewKey, parameters, this.translator);
                this.updateFileInGoogleDrive(tempFile.getFile());
            }
        } else {
            SpreadsheetDataUpdater.updateSheetData(resolvedPathToFile, this.sheetName, primaryKey, this.handleNewKey, parameters, this.translator);
        }
    }

    private void insertData(Map<String, String> parameters, String resolvedPathToFile) throws IOException {
        if (this.sourceType.equals(GOOGLE_DRIVE_SOURCE_ID)) {
            PluginInfo.checkGoogleCloudLicence();
            try (AutoCloseableTempFile tempFile = new AutoCloseableTempFile();){
                resolvedPathToFile = this.downloadFileFromGoogleDrive(tempFile);
                SpreadsheetDataWriter.writeSheetData(resolvedPathToFile, this.sheetName, parameters, this.handleExisting);
                this.updateFileInGoogleDrive(tempFile.getFile());
            }
        } else {
            SpreadsheetDataWriter.writeSheetData(resolvedPathToFile, this.sheetName, parameters, this.handleExisting);
        }
    }

    private CountedResult<Map<String, Object>> readData(Map<String, String> filters, Pagination pagination, String resolvedPathToFile) throws IOException {
        List<Map<String, Object>> data;
        if (this.sourceType.equals(GOOGLE_DRIVE_SOURCE_ID)) {
            PluginInfo.checkGoogleCloudLicence();
            try (AutoCloseableTempFile tempFile = new AutoCloseableTempFile();){
                resolvedPathToFile = this.downloadFileFromGoogleDrive(tempFile);
                data = SpreadsheetDataReader.readSheetData(resolvedPathToFile, this.sheetName, this.outputParameters, this.translator, this.defaultNumericFormat);
                data = data.stream().filter(map -> !this.areValuesEmpty((Map<String, Object>)map)).collect(Collectors.toList());
            }
        } else {
            data = SpreadsheetDataReader.readSheetData(resolvedPathToFile, this.sheetName, this.outputParameters, this.translator, this.defaultNumericFormat);
        }
        if (filters != null) {
            this.applyFilters(data, filters);
        }
        if (pagination != null) {
            this.applySort(data, pagination.getSorter());
            int subListTo = Math.min(pagination.getStart() + pagination.getLimit(), data.size());
            return new CountedResult((long)data.size(), data.subList(pagination.getStart(), subListTo));
        }
        return new CountedResult((long)data.size(), data);
    }

    private boolean areValuesEmpty(Map<String, Object> map) {
        return map.values().stream().allMatch(value -> StringUtils.isBlank((CharSequence)value.toString()));
    }

    private String downloadFileFromGoogleDrive(TempFile tempFile) throws IOException {
        GoogleIntegratorService googleIntegratorService = ExcelSpringContext.getBean(GoogleIntegratorService.class);
        ByteArrayOutputStream byteArrayOutputStream = googleIntegratorService.downloadFile(this.googleDriveConfigId, this.googleFileId);
        String resolvedPathToFile = tempFile.getFile().getAbsolutePath();
        try (FileOutputStream outputStream = new FileOutputStream(resolvedPathToFile);){
            byteArrayOutputStream.writeTo(outputStream);
        }
        return resolvedPathToFile;
    }

    private void updateFileInGoogleDrive(File fileToSend) throws IOException {
        GoogleIntegratorService googleIntegratorService = ExcelSpringContext.getBean(GoogleIntegratorService.class);
        googleIntegratorService.updateFile(this.googleDriveConfigId, this.googleFileId, fileToSend);
    }

    private Map<String, String> buildInputParameters(String[] ids, String[] names, String parametersType) {
        Assert.isTrue((ids.length == names.length ? 1 : 0) != 0, (String)(parametersType + " parameters length mismatch!"));
        return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> names[i], (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private Map<String, OutputParameter> buildOutputParameters(String[] ids, String[] names, String[] headers) {
        Assert.isTrue((ids.length == names.length && ids.length == headers.length ? 1 : 0) != 0, (String)"Output parameters length mismatch!");
        return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> new OutputParameter(names[i], headers[i]), (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private String buildPathToFile(String pathToFile) {
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG) && pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            throw new IllegalArgumentException("PathToFile only needs one {PWFL_HOME} or {WORKING_DIRECTORY} tag");
        }
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_HOME_TAG, System.getProperty("plusworkflow.home"));
        }
        if (pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_WORKING_DIRECTORY_TAG, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
        }
        return pathToFile;
    }

    private void applyFilters(List<Map<String, Object>> data, Map<String, String> filters) {
        filters.forEach((key, value) -> data.removeIf(map -> !((String)map.get(key)).toUpperCase().contains(value.toUpperCase())));
    }

    private void applySort(List<Map<String, Object>> data, Sorter sorter) {
        data.sort(Comparator.comparing(map -> String.valueOf(map.get(sorter.getProperty())).toUpperCase()));
        if (sorter.getDirection() == SortDirection.DESC) {
            Collections.reverse(data);
        }
    }

    private List<Map<String, String>> getPrimaryKey(Map<String, String> data) {
        Map<String, String> parameters = this.inputParameters.entrySet().stream().filter(parameter -> ((String)parameter.getValue()).equals("pk")).collect(Collectors.toMap(Map.Entry::getKey, parameter -> (String)data.get(parameter.getKey())));
        int maxLength = parameters.values().stream().mapToInt(s -> s.split(";").length).max().orElse(0);
        return IntStream.range(0, maxLength).mapToObj(i -> parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).split(";")[i]))).collect(Collectors.toList());
    }

    private String includeInputParameters(String stringToComplete, Map<String, String> pathParameterValues) {
        if (stringToComplete == null) {
            return null;
        }
        String result = stringToComplete;
        for (Map.Entry<String, String> pathParameter : pathParameterValues.entrySet()) {
            result = result.replace("{" + pathParameter.getKey() + "}", pathParameter.getValue());
        }
        return result;
    }

    public Set<DataSourceParameter> getInputParameters() {
        LinkedHashSet<DataSourceParameter> inputParametersSet = new LinkedHashSet<DataSourceParameter>();
        this.pathParameters.forEach((id, name) -> inputParametersSet.add(new DataSourceParameter(id, name)));
        this.inputParameters.forEach((header, type) -> inputParametersSet.add(new DataSourceParameter(header, this.getOperation() == DataSourceOperation.UPDATE && type.equalsIgnoreCase("pk") ? header + " [" + type.toUpperCase() + "]" : header)));
        return inputParametersSet;
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters.entrySet().stream().map(outputParameter -> new DataSourceParameter((String)outputParameter.getKey(), ((OutputParameter)outputParameter.getValue()).getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

