/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.writers;

import com.suncode.plugin.datasource.csv.common.CsvFileUtils;
import com.suncode.plugin.datasource.csv.common.CsvUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;

public class CSVDataWriter {
    public static void writeData(String pathToFile, Map<String, String> parameters, CSVFormat csvFormat, Charset charset, String handleExisting, Boolean useHeaderData) {
        if (handleExisting.equalsIgnoreCase("override")) {
            CSVDataWriter.createNewCsvFile(pathToFile, parameters, csvFormat, charset, useHeaderData);
            return;
        }
        CSVDataWriter.updateCsvFile(pathToFile, parameters, csvFormat, charset, useHeaderData);
    }

    private static void updateCsvFile(String pathToFile, Map<String, String> parameters, CSVFormat csvFormat, Charset charset, Boolean useHeaderData) throws IOException {
        Boolean existsCsvFile = CsvUtils.doesFileExist(pathToFile);
        List<String> headerNames = CSVDataWriter.getHeaderNames(pathToFile, parameters, csvFormat, existsCsvFile, charset, useHeaderData);
        try (Writer fileWriter = CsvFileUtils.getFileWriter(pathToFile, true, charset);){
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);
            if (Boolean.FALSE.equals(existsCsvFile) && Boolean.TRUE.equals(useHeaderData)) {
                csvPrinter.printRecord(headerNames);
            }
            List<Map<String, String>> rowsToInsert = CsvUtils.buildRowsToInsert(parameters);
            csvPrinter.printRecords(CsvUtils.getRecords(rowsToInsert, headerNames));
        }
    }

    private static void createNewCsvFile(String pathToFile, Map<String, String> parameters, CSVFormat csvFormat, Charset charset, Boolean useHeaderData) throws IOException {
        Files.deleteIfExists(Paths.get(pathToFile, new String[0]));
        List<String> headerNames = CSVDataWriter.getHeaderNames(pathToFile, parameters, csvFormat, false, charset, useHeaderData);
        try (Writer fileWriter = CsvFileUtils.getFileWriter(pathToFile, true, charset);){
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);
            if (Boolean.TRUE.equals(useHeaderData)) {
                csvPrinter.printRecord(headerNames);
            }
            List<Map<String, String>> rowsToInsert = CsvUtils.buildRowsToInsert(parameters);
            csvPrinter.printRecords(CsvUtils.getRecords(rowsToInsert, headerNames));
        }
    }

    private static List<String> getHeaderNames(String pathToFile, Map<String, String> parameters, CSVFormat csvFormat, Boolean existsCSVFIle, Charset charset, Boolean useHeaderData) throws IOException {
        List<String> headerNames = new LinkedList<String>();
        if (Boolean.TRUE.equals(existsCSVFIle) && Boolean.TRUE.equals(useHeaderData)) {
            try (Reader fileReader = CsvFileUtils.getFileReader(pathToFile, charset);
                 CSVParser csvFileParser = new CSVParser(fileReader, csvFormat);){
                headerNames = csvFileParser.getHeaderNames();
            }
        }
        if (headerNames.isEmpty()) {
            headerNames.addAll(parameters.keySet());
        }
        return headerNames;
    }
}

