/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.updaters;

import com.suncode.plugin.datasource.csv.collections.CSVInputParameterWithValue;
import com.suncode.plugin.datasource.csv.common.CsvFileUtils;
import com.suncode.plugin.datasource.csv.common.CsvUtils;
import com.suncode.plugin.datasource.csv.common.HandleNewKey;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataUpdater {
    private static final Logger log = LoggerFactory.getLogger(CSVDataUpdater.class);

    public static void updateData(String pathToFile, Map<String, String> primaryKey, HandleNewKey handleNewKey, List<CSVInputParameterWithValue> csvInputParameters, CSVFormat csvFormat, Charset charset, Boolean useHeaderData, Translator translator) {
        if (!CsvUtils.doesFileExist(pathToFile).booleanValue()) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + pathToFile);
        }
        TempFile tempFile = new TempFile();
        try (Reader fileReader = CsvFileUtils.getFileReader(pathToFile, charset);
             Writer fileWriter = CsvFileUtils.getFileWriter(tempFile.getFile().getPath(), true, charset);){
            CSVParser csvFileParser = new CSVParser(fileReader, csvFormat);
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);
            ArrayList<String> headerNames = new ArrayList();
            if (useHeaderData.booleanValue()) {
                headerNames = csvFileParser.getHeaderNames();
                csvPrinter.printRecord(headerNames);
            }
            List records = csvFileParser.getRecords();
            Map parametersMap = csvInputParameters.stream().collect(Collectors.toMap(CSVInputParameterWithValue::getName, CSVInputParameterWithValue::getValue, (existing, candidate) -> existing, LinkedHashMap::new));
            List<Map<String, String>> rows = CsvUtils.buildRowsToInsert(parametersMap);
            List<Map<String, String>> pkRow = CsvUtils.buildRowsToInsert(primaryKey);
            ArrayList<Map<String, String>> addRow = new ArrayList<Map<String, String>>(rows);
            for (CSVRecord record : records) {
                Boolean notUpdated = true;
                for (int index = 0; index < rows.size(); ++index) {
                    Map<String, String> oneRow = rows.get(index);
                    boolean primaryKeysMatch = useHeaderData != false ? CsvUtils.checkPrimaryKey(pkRow.get(index), record).booleanValue() : CsvUtils.checkPrimaryKeyByIndex(csvInputParameters, record).booleanValue();
                    if (!primaryKeysMatch) continue;
                    csvPrinter.printRecord(CSVDataUpdater.updateRecord(oneRow, headerNames, record, useHeaderData));
                    if (addRow.contains(oneRow)) {
                        addRow.remove(oneRow);
                    }
                    notUpdated = false;
                    break;
                }
                if (!notUpdated.booleanValue()) continue;
                csvPrinter.printRecord((Iterable)record);
            }
            if (!addRow.isEmpty()) {
                if (handleNewKey == HandleNewKey.ADD) {
                    if (useHeaderData.booleanValue()) {
                        csvPrinter.printRecords(CsvUtils.getRecords(addRow, headerNames));
                    } else {
                        csvPrinter.printRecords(CsvUtils.getRecords(addRow));
                    }
                } else {
                    if (handleNewKey == HandleNewKey.BLOCK) {
                        throw new Exception(translator.getMessage("error.rowNotFound") + ": " + primaryKey);
                    }
                    if (handleNewKey == HandleNewKey.PASS) {
                        log.warn("Row with following primary key " + primaryKey + " not found!");
                    }
                }
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)tempFile.getFile());
            throw e;
        }
        CsvUtils.copyFile(pathToFile, tempFile);
    }

    private static List<String> updateRecord(Map<String, String> parameters, List<String> headerNames, CSVRecord record, Boolean useHeaderData) {
        LinkedList<String> updatedRecord = new LinkedList<String>();
        if (useHeaderData.booleanValue()) {
            for (String headerName : headerNames) {
                if (parameters.containsKey(headerName)) {
                    updatedRecord.add(parameters.get(headerName));
                    continue;
                }
                updatedRecord.add(record.get(headerName));
            }
        } else {
            ArrayList<String> updatingValues = new ArrayList<String>(parameters.values());
            for (int i = 0; i < record.size(); ++i) {
                if (i < updatingValues.size()) {
                    updatedRecord.add((String)updatingValues.get(i));
                    continue;
                }
                updatedRecord.add(record.get(i));
            }
        }
        return updatedRecord;
    }
}

