/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.readers;

import com.suncode.plugin.datasource.csv.collections.CSVOutputParameter;
import com.suncode.plugin.datasource.csv.common.CsvFileUtils;
import com.suncode.plugin.datasource.csv.common.CsvUtils;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.SpringContext;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataReader {
    private static final Logger log = LoggerFactory.getLogger(CSVDataReader.class);

    public static List<Map<String, Object>> readData(String pathToFile, List<CSVOutputParameter> outputParameters, CSVFormat csvFormat, Charset charset, Boolean useHeaderData, Translator translator) {
        String resolvedPathToFile = CSVDataReader.resolveFilePathByFileId(pathToFile);
        log.info("Resolved path to file: " + resolvedPathToFile);
        if (!CsvUtils.doesFileExist(resolvedPathToFile).booleanValue()) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + resolvedPathToFile);
        }
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        try (Reader fileReader = CsvFileUtils.getFileReader(resolvedPathToFile, charset);){
            CSVParser records = csvFormat.parse(fileReader);
            for (CSVRecord record : records) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int index = 0; index < outputParameters.size(); ++index) {
                    Object value = useHeaderData != false ? CsvUtils.convertType(record.get(outputParameters.get(index).getHeader()), outputParameters.get(index).getType()) : CsvUtils.convertType(record.get(index), outputParameters.get(index).getType());
                    row.put(outputParameters.get(index).getId(), value);
                }
                result.add(row);
            }
        }
        return result;
    }

    private static String resolveFilePathByFileId(String pathToFile) {
        if (pathToFile.startsWith("FILEID:{")) {
            FileService fileService = (FileService)SpringContext.getBean(FileService.class);
            long fileId = Long.parseLong(StringUtils.substringBetween((String)pathToFile, (String)"{", (String)"}"));
            WfFile file = fileService.getFile(Long.valueOf(fileId), new String[0]);
            return file.getFullPath();
        }
        return pathToFile;
    }
}

