/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.erasers;

import com.suncode.plugin.datasource.csv.common.CsvFileUtils;
import com.suncode.plugin.datasource.csv.common.CsvUtils;
import com.suncode.plugin.datasource.csv.common.DeleteType;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;

public class CSVDataEraser {
    public static void deleteData(String pathToFile, CSVFormat csvFormat, Map<String, String> primaryKey, DeleteType deleteType, Charset charset, Translator translator) {
        if (!CsvUtils.doesFileExist(pathToFile).booleanValue()) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + pathToFile);
        }
        TempFile tempFile = new TempFile();
        try (Reader fileReader = CsvFileUtils.getFileReader(pathToFile, charset);
             Writer fileWriter = CsvFileUtils.getFileWriter(tempFile.getFile().getPath(), true, charset);){
            CSVParser csvFileParser = new CSVParser(fileReader, csvFormat);
            List headerNames = csvFileParser.getHeaderNames();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, csvFormat);
            csvPrinter.printRecord((Iterable)headerNames);
            List records = csvFileParser.getRecords();
            List<Map<String, String>> pkRows = CsvUtils.buildRowsToInsert(primaryKey);
            for (CSVRecord record : records) {
                Boolean rewrite = true;
                Map<String, String> firstRemove = null;
                for (Map<String, String> pkRow : pkRows) {
                    if (!CsvUtils.checkPrimaryKey(pkRow, record).booleanValue()) continue;
                    rewrite = false;
                    if (deleteType != DeleteType.FIRST) break;
                    firstRemove = pkRow;
                    break;
                }
                if (deleteType == DeleteType.FIRST && firstRemove != null) {
                    pkRows.remove(firstRemove);
                }
                if (!rewrite.booleanValue()) continue;
                csvPrinter.printRecord((Iterable)record);
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)tempFile.getFile());
            throw new RuntimeException(e.getMessage(), e);
        }
        CsvUtils.copyFile(pathToFile, tempFile);
    }
}

