/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.controller;

import com.suncode.plugin.datasource.csv.charset.SupportedCsvCharset;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"form"})
public class DpweCsvFormController {
    @RequestMapping(value={"charsets"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getCharsets(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        List charsets = Arrays.stream(SupportedCsvCharset.values()).filter(charset -> this.isCharsetSupported(query, (SupportedCsvCharset)((Object)charset))).sorted(Comparator.comparing(SupportedCsvCharset::getCharsetName)).map(charset -> Collections.singletonMap("name", charset.getCharsetName())).collect(Collectors.toList());
        int totalResult = charsets.size();
        Long startL = Long.valueOf(start);
        CountedResult result = new CountedResult();
        Long limitL = Long.valueOf(limit);
        result.setData(totalResult > limitL.intValue() ? charsets.subList(startL.intValue(), Math.min(startL.intValue() + limitL.intValue(), charsets.size())) : charsets);
        result.setTotal((long)totalResult);
        return result;
    }

    private boolean isCharsetSupported(String query, SupportedCsvCharset charset) {
        return StringUtils.isBlank((CharSequence)query) || StringUtils.isNotBlank((CharSequence)query) && charset.getCharsetName().toUpperCase().contains(query.toUpperCase());
    }
}

