/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.component;

import com.suncode.plugin.datasource.csv.collections.CSVInputParameter;
import com.suncode.plugin.datasource.csv.collections.CSVInputParameterWithValue;
import com.suncode.plugin.datasource.csv.collections.CSVOutputParameter;
import com.suncode.plugin.datasource.csv.common.CsvInputType;
import com.suncode.plugin.datasource.csv.common.CsvUtils;
import com.suncode.plugin.datasource.csv.common.DeleteType;
import com.suncode.plugin.datasource.csv.common.HandleNewKey;
import com.suncode.plugin.datasource.csv.common.Types;
import com.suncode.plugin.datasource.csv.erasers.CSVDataEraser;
import com.suncode.plugin.datasource.csv.readers.CSVDataReader;
import com.suncode.plugin.datasource.csv.updaters.CSVDataUpdater;
import com.suncode.plugin.datasource.csv.writers.CSVDataWriter;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceContext;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.translation.Translator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CSVDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(CSVDataSource.class);
    private static final String PLUSWORKFLOW_HOME_TAG = "{PWFL_HOME}";
    private static final String PLUSWORKFLOW_WORKING_DIRECTORY_TAG = "{WORKING_DIRECTORY}";
    private final String pathToFile;
    private final String handleExisting;
    private final List<CSVInputParameter> inputParameters;
    private final List<CSVOutputParameter> outputParameters;
    private final Map<String, String> pathParameters;
    private final CSVFormat csvFormat;
    private final DeleteType deleteType;
    private final HandleNewKey handleNewKey;
    private final Translator translator;
    private Charset charset;
    private Boolean useHeaderData;

    public CSVDataSource(Parameters parameters, DataSourceContext context, Translator translator) {
        this.pathToFile = this.buildPathToFile((String)parameters.get("pathToFile", String.class));
        this.handleExisting = (String)parameters.get("handleExisting", String.class);
        this.pathParameters = this.buildPathInputParameters((String[])parameters.get("pathParametersId", String[].class), (String[])parameters.get("pathParametersName", String[].class), "Path");
        this.charset = Charset.forName((String)parameters.get("charsetName", String.class));
        this.inputParameters = this.buildCSVInputParameters(parameters, context);
        this.outputParameters = this.buildCSVOutputParameters(parameters);
        this.csvFormat = CsvUtils.buildFormat(parameters);
        this.deleteType = this.buildDeleteType(parameters);
        this.handleNewKey = this.buildHandleNewKey(parameters);
        this.useHeaderData = (Boolean)parameters.get("useHeaderData", Boolean.class);
        this.translator = translator;
    }

    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        log.info("CSV DataSources executed with following parameters: " + parameters);
        String resolvedPathToFile = this.extractPathParameters(parameters);
        if (this.getOperation() != DataSourceOperation.READ) {
            log.info("Resolved path to file: " + resolvedPathToFile);
        }
        Assert.isTrue((parameters.values().stream().filter(value -> value.contains(";")).map(value -> value.split(";", -1).length).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Arrays parameters values are not equal in size!");
        switch (this.getOperation()) {
            case DELETE: {
                CSVDataEraser.deleteData(resolvedPathToFile, this.csvFormat, new LinkedHashMap<String, String>(parameters), this.deleteType, this.charset, this.translator);
                return new CountedResult(0L, new ArrayList());
            }
            case INSERT: {
                CSVDataWriter.writeData(resolvedPathToFile, this.inputParameters.stream().collect(Collectors.toMap(CSVInputParameter::getHeader, param -> (String)parameters.get(param.getHeader()), (existing, candidate) -> existing, LinkedHashMap::new)), this.csvFormat, this.charset, this.handleExisting, this.useHeaderData);
                return new CountedResult(0L, new ArrayList());
            }
            case READ: {
                List<Map<String, Object>> data = CSVDataReader.readData(resolvedPathToFile, this.outputParameters, this.csvFormat, this.charset, this.useHeaderData, this.translator);
                if (filters != null) {
                    this.applyFilters(data, filters);
                }
                if (pagination != null) {
                    this.applySort(data, pagination.getSorter());
                }
                List<Map<String, Object>> resultData = pagination == null ? data : data.subList(pagination.getStart(), Math.min(pagination.getStart() + pagination.getLimit(), data.size()));
                return new CountedResult((long)data.size(), resultData);
            }
            case UPDATE: {
                LinkedHashMap<String, String> allData = new LinkedHashMap<String, String>(parameters);
                List<CSVInputParameterWithValue> inputParametersWithValue = this.buildInputParametersWithValue(allData);
                CSVDataUpdater.updateData(resolvedPathToFile, this.getPrimaryKey(allData), this.handleNewKey, inputParametersWithValue, this.csvFormat, this.charset, this.useHeaderData, this.translator);
                return new CountedResult(0L, new ArrayList());
            }
        }
        throw new UnsupportedOperationException();
    }

    public Set<DataSourceParameter> getInputParameters() {
        LinkedHashSet<DataSourceParameter> inputParametersSet = new LinkedHashSet<DataSourceParameter>();
        this.pathParameters.forEach((id, name) -> inputParametersSet.add(new DataSourceParameter(id, name)));
        this.inputParameters.forEach(parameter -> inputParametersSet.add(new DataSourceParameter(parameter.getHeader(), parameter.getType() == CsvInputType.PRIMARY_KEY ? "[PK] " : "" + parameter.getHeader())));
        return inputParametersSet;
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters.stream().map(parameter -> new DataSourceParameter(parameter.getId(), parameter.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private HandleNewKey buildHandleNewKey(Parameters parameters) {
        String handleNewKeyStr = (String)parameters.get("handleNewKey", String.class);
        return StringUtils.isBlank((CharSequence)handleNewKeyStr) ? HandleNewKey.BLOCK : HandleNewKey.valueOf(handleNewKeyStr);
    }

    private DeleteType buildDeleteType(Parameters parameters) {
        String deleteTypeStr = (String)parameters.get("deleteType", String.class);
        return StringUtils.isBlank((CharSequence)deleteTypeStr) ? DeleteType.FIRST : DeleteType.valueOf(deleteTypeStr);
    }

    private List<CSVOutputParameter> buildCSVOutputParameters(Parameters parameters) {
        return this.buildOutputParameters((String[])parameters.get("outputParametersId", String[].class), (String[])parameters.get("outputParametersName", String[].class), (String[])parameters.get("outputParametersHeader", String[].class), (String[])parameters.get("outputParametersType", String[].class));
    }

    private String buildPathToFile(String pathToFile) {
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG) && pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            throw new IllegalArgumentException("PathToFile only needs one {PWFL_HOME} or {WORKING_DIRECTORY} tag");
        }
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_HOME_TAG, System.getProperty("plusworkflow.home"));
        }
        if (pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_WORKING_DIRECTORY_TAG, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
        }
        return pathToFile;
    }

    private Map<String, String> buildPathInputParameters(String[] ids, String[] names, String parametersType) {
        Assert.isTrue((ids.length == names.length ? 1 : 0) != 0, (String)(parametersType + " parameters length mismatch!"));
        return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> names[i], (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private String extractPathParameters(Map<String, String> data) {
        String resolvedPathToFile = this.pathToFile;
        for (Map.Entry<String, String> pathParameter : this.pathParameters.entrySet()) {
            resolvedPathToFile = resolvedPathToFile.replace("{" + pathParameter.getKey() + "}", this.getOperation() == DataSourceOperation.READ ? (CharSequence)data.get(pathParameter.getKey()) : (CharSequence)data.remove(pathParameter.getKey()));
        }
        return resolvedPathToFile;
    }

    private List<CSVInputParameter> buildCSVInputParameters(Parameters parameters, DataSourceContext context) {
        String[] headers = (String[])parameters.get("inputParametersHeader", String[].class);
        String[] types = context.getOperation() == DataSourceOperation.UPDATE ? (String[])parameters.get("inputParametersType", String[].class) : new String[headers.length];
        return this.buildInputParameters(headers, types);
    }

    private List<CSVOutputParameter> buildOutputParameters(String[] ids, String[] names, String[] headers, String[] type) {
        Assert.isTrue((ids.length == names.length && ids.length == headers.length && headers.length == type.length ? 1 : 0) != 0, (String)"Output parameters length mismatch!");
        return IntStream.range(0, ids.length).boxed().map(i -> new CSVOutputParameter(ids[i], names[i], headers[i], StringUtils.isBlank((CharSequence)type[i]) ? Types.STRING : Types.valueOf(type[i]))).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<CSVInputParameter> buildInputParameters(String[] headers, String[] types) {
        Assert.isTrue((headers.length == types.length ? 1 : 0) != 0, (String)"Input parameters length mismatch!");
        return IntStream.range(0, headers.length).boxed().map(i -> new CSVInputParameter(headers[i], types[i])).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<CSVInputParameterWithValue> buildInputParametersWithValue(Map<String, String> data) {
        return this.inputParameters.stream().map(parameter -> new CSVInputParameterWithValue(parameter.getHeader(), (String)data.get(parameter.getHeader()), parameter.getType())).collect(Collectors.toList());
    }

    private Map<String, String> getPrimaryKey(Map<String, String> data) {
        return this.inputParameters.stream().filter(parameter -> parameter.getType() == CsvInputType.PRIMARY_KEY).collect(Collectors.toMap(CSVInputParameter::getHeader, parameter -> (String)data.get(parameter.getHeader())));
    }

    private void applyFilters(List<Map<String, Object>> data, Map<String, String> filters) {
        filters.entrySet().forEach(entry -> data.removeIf(map -> !((String)map.get(entry.getKey())).toUpperCase().contains(((String)entry.getValue()).toUpperCase())));
    }

    private void applySort(List<Map<String, Object>> data, Sorter sorter) {
        data.sort(Comparator.comparing(map -> String.valueOf(map.get(sorter.getProperty())).toUpperCase()));
        if (sorter.getDirection() == SortDirection.DESC) {
            Collections.reverse(data);
        }
    }
}

