/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.csv.common;

import com.suncode.plugin.datasource.csv.collections.CSVInputParameterWithValue;
import com.suncode.plugin.datasource.csv.common.Types;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.util.TempFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    private static final Logger log = LoggerFactory.getLogger(CsvUtils.class);
    private static final String[] DATE_PATTERNS = new String[]{"dd/MM/yyyy", "dd.MM.yyyy", "dd-MM-yyyy"};
    private static final String[] DATETIME_PATTERNS = new String[]{"dd.MM.yyyy HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "dd-MM-yyyy HH:mm:ss"};

    public static Object convertType(String value, Types type) throws ParseException {
        log.debug("Convert value from : " + value + " to type " + type.name());
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        switch (type) {
            case BOOLEAN: {
                if (value.replaceAll("\\W", "").contains("1")) {
                    return BooleanUtils.toBoolean((Boolean)true);
                }
                return BooleanUtils.toBoolean((String)value);
            }
            case DATE: {
                if (value.matches("([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]))")) {
                    return value;
                }
                if (value.matches("\\d{2}[-.\\/]\\d{2}[-.\\/]\\d{4}")) {
                    DateTimeFormatter plusworkflowDateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
                    Date date = DateUtils.parseDate((String)value, (String[])DATE_PATTERNS);
                    return date == null ? "" : new LocalDate((Object)date).toString(plusworkflowDateFormat);
                }
                throw new IllegalArgumentException("Format not suporrted: " + value);
            }
            case DATETIME: {
                if (value.matches("([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01])) ([012]\\d):([0-6]\\d):([0-6]\\d)")) {
                    return value;
                }
                if (value.matches("\\d{2}[-.\\/]\\d{2}[-.\\/]\\d{4} ([012]\\d):([0-6]\\d):([0-6]\\d)")) {
                    DateTimeFormatter plusworkflowDateTimeFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                    Date datetime = DateUtils.parseDate((String)value, (String[])DATETIME_PATTERNS);
                    return datetime == null ? "" : new LocalDateTime((Object)datetime).toString(plusworkflowDateTimeFormat);
                }
                throw new IllegalArgumentException("Format not suporrted: " + value);
            }
            case FLOAT: {
                return Double.valueOf(value.replaceAll(",", ".").replaceAll("[^(a-zA-Z0-9.,)]", ""));
            }
            case INTEGER: {
                return Long.valueOf(value.replaceAll("\\W", ""));
            }
        }
        return value;
    }

    public static CSVFormat buildFormat(Parameters parameters) {
        boolean useHeaderData;
        CSVFormat csvFormat;
        String format = (String)parameters.get("format", String.class);
        if (StringUtils.isBlank((CharSequence)format) || format.equalsIgnoreCase("CUSTOM")) {
            String quoteChar;
            csvFormat = CSVFormat.DEFAULT;
            String separator = (String)parameters.get("separator", String.class);
            if (StringUtils.isNotBlank((CharSequence)separator)) {
                csvFormat = csvFormat.withDelimiter(separator.charAt(0)).withQuoteMode(QuoteMode.ALL);
            }
            if (StringUtils.isNotBlank((CharSequence)(quoteChar = (String)parameters.get("quoteChar", String.class)))) {
                csvFormat = quoteChar.equalsIgnoreCase("null") ? csvFormat.withQuote(null) : csvFormat.withQuote(quoteChar.charAt(0));
            }
        } else if (StringUtils.isBlank((CharSequence)format) || format.equalsIgnoreCase("PLUSWORKFLOW")) {
            csvFormat = CSVFormat.DEFAULT;
            csvFormat = csvFormat.withDelimiter(',').withQuote('\'').withQuoteMode(QuoteMode.ALL);
        } else {
            csvFormat = CSVFormat.valueOf((String)format);
        }
        boolean bl = useHeaderData = parameters.get("useHeaderData", Boolean.class) == null || (Boolean)parameters.get("useHeaderData", Boolean.class) != false;
        if (useHeaderData) {
            return csvFormat.withFirstRecordAsHeader().withAutoFlush(true);
        }
        return csvFormat.withAutoFlush(true);
    }

    public static Boolean doesFileExist(String path) {
        return new File(path).exists();
    }

    public static Boolean checkPrimaryKey(Map<String, String> primaryKey, CSVRecord record) {
        return primaryKey.keySet().stream().filter(arg_0 -> ((CSVRecord)record).isMapped(arg_0)).allMatch(key -> record.get(key).equals(primaryKey.get(key)));
    }

    public static Boolean checkPrimaryKeyByIndex(List<CSVInputParameterWithValue> parameters, CSVRecord record) {
        return IntStream.range(0, parameters.size()).filter(index -> ((CSVInputParameterWithValue)parameters.get(index)).getType().name().equals("PRIMARY_KEY")).allMatch(index -> record.get(index).equals(((CSVInputParameterWithValue)parameters.get(index)).getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String pathToFile, TempFile tempFile) throws IOException {
        try (FileInputStream readerTempFile = new FileInputStream(tempFile.getFile());){
            FileUtils.copyInputStreamToFile((InputStream)readerTempFile, (File)new File(pathToFile));
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile.getFile());
        }
    }

    public static List<List<String>> getRecords(List<Map<String, String>> rowsToInsert) {
        return rowsToInsert.stream().map(map -> map.values().stream().collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static List<List<String>> getRecords(List<Map<String, String>> rowsToInsert, List<String> headerNames) {
        return rowsToInsert.stream().map(entry -> headerNames.stream().map(header -> entry.getOrDefault(header, "")).collect(Collectors.toCollection(LinkedList::new))).collect(Collectors.toCollection(LinkedList::new));
    }

    public static List<Map<String, String>> buildRowsToInsert(Map<String, String> parameters) {
        int maxLength = parameters.values().stream().mapToInt(s -> s.split(";", -1).length).max().orElse(0);
        List rowsToInsert = IntStream.range(0, maxLength).boxed().map(i -> parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CsvUtils.getRowValue((String)e.getValue(), i), (existing, candidate) -> existing, LinkedHashMap::new))).collect(Collectors.toCollection(LinkedList::new));
        return rowsToInsert;
    }

    private static String getRowValue(String values, int index) {
        if (values.contains(";")) {
            String[] arr = values.split(";", -1);
            return arr.length > index ? arr[index] : "";
        }
        return values;
    }
}

