/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eventfunctions.util;

import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.ContextVariableBuilder;
import com.suncode.pwfl.component.ParameterDefinitionBuilder;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.form.eventaction.EventActionDefinitionBuilder;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class ActionsUtil {
    private static final String DESC_TAG = ".desc";
    private static final String NAME_TAG = ".name";
    private static final String PARAM_TAG = ".param.";
    private static final String CONTEXT_PARAM_TAG = ".param.context.";
    private static final String EVENTS_TAG = ".events.";
    private static final String EVENTS_PARAM_TAG = ".events.param.";

    private ActionsUtil() {
    }

    public static EventActionDefinitionBuilder defaultHeader(EventActionDefinitionBuilder builder, String actionId, Icon icon, Category category) {
        return ActionsUtil.defaultHeader(builder, actionId, icon, category, true);
    }

    public static EventActionDefinitionBuilder defaultHeader(EventActionDefinitionBuilder builder, String actionId, Icon icon, Category category, boolean addDescriptionId) {
        ((EventActionDefinitionBuilder)((EventActionDefinitionBuilder)((EventActionDefinitionBuilder)builder.id(actionId)).name(actionId + NAME_TAG)).icon(icon)).category(new Category[]{category});
        if (addDescriptionId) {
            builder.description(actionId + DESC_TAG);
        }
        return builder;
    }

    public static ParameterDefinitionBuilder<EventActionDefinitionBuilder> parameterBuilder(EventActionDefinitionBuilder builder, String actionId, String parameterId, Type type) {
        return ActionsUtil.parameterBuilder(builder, actionId, parameterId, type, true, false);
    }

    public static ParameterDefinitionBuilder<EventActionDefinitionBuilder> parameterBuilder(EventActionDefinitionBuilder builder, String actionId, String parameterId, Type type, boolean hasDescription) {
        return ActionsUtil.parameterBuilder(builder, actionId, parameterId, type, hasDescription, false);
    }

    public static ParameterDefinitionBuilder<EventActionDefinitionBuilder> parameterBuilder(EventActionDefinitionBuilder builder, String actionId, String parameterId, Type type, boolean hasDescription, boolean isOptional) {
        return ActionsUtil.parameterBuilder(builder, actionId, parameterId, type, hasDescription, isOptional, null);
    }

    public static ParameterDefinitionBuilder<EventActionDefinitionBuilder> parameterBuilder(EventActionDefinitionBuilder builder, String actionId, String parameterId, Type type, boolean hasDescription, boolean isOptional, Object defaultValue) {
        ParameterDefinitionBuilder parameterDefinition = builder.parameter();
        if (hasDescription) {
            parameterDefinition.description(actionId + PARAM_TAG + parameterId + DESC_TAG);
        }
        if (isOptional) {
            parameterDefinition.optional();
        }
        if (defaultValue != null) {
            parameterDefinition.defaultValue(defaultValue);
        }
        return parameterDefinition.id(parameterId).name(actionId + PARAM_TAG + parameterId + NAME_TAG).type(type);
    }

    public static EventActionDefinitionBuilder.EventBuilder eventBuilder(EventActionDefinitionBuilder builder, String actionId, String eventId, EventParam ... params) {
        EventActionDefinitionBuilder.EventBuilder event = ActionsUtil.eventBuilder(builder, actionId, eventId);
        Arrays.stream(params).forEach(param -> {
            EventActionDefinitionBuilder.EventBuilder.EventPropertyBuilder property = event.property(((EventParam)param).id);
            property.name(actionId + EVENTS_TAG + eventId + PARAM_TAG + ((EventParam)param).id + NAME_TAG);
            property.type(((EventParam)param).type);
            if (((EventParam)param).hasDescription) {
                property.description(actionId + EVENTS_TAG + eventId + PARAM_TAG + ((EventParam)param).id + DESC_TAG);
            }
        });
        return event;
    }

    public static EventActionDefinitionBuilder.EventBuilder eventBuilder(EventActionDefinitionBuilder builder, String actionId, String eventId) {
        return builder.event(eventId).description(actionId + EVENTS_TAG + eventId + DESC_TAG);
    }

    public static ContextVariableBuilder<EventActionDefinitionBuilder> contextParameterBuilder(EventActionDefinitionBuilder builder, String actionId, String parameterId, Type type, boolean hasDescription) {
        ContextVariableBuilder contextParameterDefinition = builder.contextVariable();
        if (hasDescription) {
            contextParameterDefinition.description(actionId + PARAM_TAG + parameterId + DESC_TAG);
        }
        return contextParameterDefinition.id(parameterId).name(actionId + CONTEXT_PARAM_TAG + parameterId + NAME_TAG).type(type);
    }

    public static class EventParam {
        private String id;
        private Type type;
        private boolean hasDescription;

        @ConstructorProperties(value={"id", "type", "hasDescription"})
        public EventParam(String id, Type type, boolean hasDescription) {
            this.id = id;
            this.type = type;
            this.hasDescription = hasDescription;
        }
    }
}

