/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eventfunctions.servlets;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.eventfunctions.servlets.dto.AddBase64DocumentRequestDto;
import com.suncode.plugin.eventfunctions.servlets.dto.AddBase64DocumentResponseDto;
import com.suncode.plugin.eventfunctions.servlets.dto.DocumentClassChangeAndSetIndexesRequestDto;
import com.suncode.plugin.eventfunctions.servlets.dto.DocumentClassDto;
import com.suncode.plugin.eventfunctions.servlets.dto.DocumentClassIndexDto;
import com.suncode.plugin.eventfunctions.servlets.dto.IndexMapDto;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"document"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    private static final String DEFAULT_ADMINISTRATOR_USERNAME = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME");
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private ActivityDocumentService activityDocumentService;

    @RequestMapping(value={"changeDocumentClassAndSetIndexes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public Map<Long, Long> changeDocumentClassAndSetIndexes(@RequestBody DocumentClassChangeAndSetIndexesRequestDto request) {
        HashSet<Long> uniqueFileIdsSet = new HashSet<Long>(Arrays.asList(request.getFileIds()));
        Long[] uniqueFilteredFileIds = this.getFileIdsContainingDocumentClasses(uniqueFileIdsSet, request.getFilterByDocumentClass());
        HashMap<Long, Long> idPairs = new HashMap<Long, Long>();
        for (int i = 0; i < uniqueFilteredFileIds.length; ++i) {
            this.changeDocumentClass(request.getProcessId(), uniqueFilteredFileIds[i], request.getTargetDocumentClass(), idPairs);
        }
        for (Map.Entry entry : idPairs.entrySet()) {
            this.changeDocumentIndexes((Long)entry.getValue(), request.getFileIdIndexMapDto().get(entry.getKey()));
        }
        return idPairs;
    }

    @RequestMapping(value={"classes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassDto> getDocumentClasses(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List documentClasses = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (documentClasses.size() >= start) {
            result.setData(documentClasses.subList(start, Integer.min(start + limit, documentClasses.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClasses.size());
        return this.convertToDto(result, DocumentClassDto::new);
    }

    @ResponseBody
    @RequestMapping(value={"classes/{documentClass}/indices"}, method={RequestMethod.GET})
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexes(@PathVariable String documentClass, @RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        Long docClassId = this.getDocumentClassId(documentClass);
        List indices = this.documentClassIndexFinder.findByDocumentClass(docClassId).stream().filter(documentClassIndex -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)documentClassIndex.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClassIndex::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (start == null || limit == null) {
            result.setData(indices);
            result.setTotal((long)indices.size());
            return this.convertToDto(result, DocumentClassIndexDto::new);
        }
        if (indices.size() >= start) {
            result.setData(indices.subList(start, Integer.min(start + limit, indices.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)indices.size());
        return this.convertToDto(result, DocumentClassIndexDto::new);
    }

    @ResponseBody
    @RequestMapping(value={"addBase64Document"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    public AddBase64DocumentResponseDto addBase64Document(@RequestBody AddBase64DocumentRequestDto requestDto) throws Exception {
        byte[] bytes = Base64.getMimeDecoder().decode(requestDto.getBase64Input());
        String newVersionMode = requestDto.getNewVersionMode();
        boolean saveAsNewVersion = !newVersionMode.equalsIgnoreCase("none");
        DocumentDefinition documentDefinition = this.createNewDocumentDefinition(Long.valueOf(requestDto.getDocumentClass()), new ByteArrayInputStream(bytes), requestDto.getDocumentName(), requestDto.getDocumentDescription(), DEFAULT_ADMINISTRATOR_USERNAME, null, null, saveAsNewVersion, requestDto.getIndices());
        WfDocument addedDocument = this.getWfDocument(requestDto, newVersionMode, documentDefinition);
        if (Boolean.TRUE.equals(requestDto.getExecuteDocumentClassActions())) {
            this.documentClassActionService.executeArchiveActions(addedDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        }
        String documentClassName = ((DocumentClass)this.documentClassService.get((Serializable)addedDocument.getDocumentClassId())).getName();
        return AddBase64DocumentResponseDto.builder().documentClassName(documentClassName).fileId(addedDocument.getId()).build();
    }

    @ResponseBody
    @RequestMapping(value={"/attachDocumentToProcess"}, method={RequestMethod.POST})
    public boolean attachDocumentToProcess(@RequestParam long fileId, @RequestParam String username, @RequestParam String processId, @RequestParam String activityId) {
        try {
            ActivityDocument activityDocument = this.activityDocumentService.getActivityDocument(fileId, activityId);
            if (activityDocument == null) {
                WfFile file = this.fileService.getFile(Long.valueOf(fileId), new String[]{"documentClass"});
                if (file == null) {
                    log.error("File not found (ID: {}", (Object)fileId);
                    return false;
                }
                WfDocument wfDocument = this.documentFinder.findByFileId(Long.valueOf(fileId), file.getDocumentClass().getId());
                if (wfDocument == null) {
                    log.error("Document not found (file ID: {})", (Object)fileId);
                    return false;
                }
                this.documentService.attachDocumentToProcess(wfDocument, username, processId, activityId);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/detachDocumentFromProcess"}, method={RequestMethod.POST})
    public boolean detachDocumentFromProcess(@RequestParam long fileId, @RequestParam String processId, @RequestParam String activityId) {
        try {
            ActivityDocument activityDocument = this.activityDocumentService.getActivityDocument(fileId, activityId);
            if (activityDocument == null) {
                log.error("Document not found (file ID: {})", (Object)fileId);
                return false;
            }
            this.activityDocumentService.detachDocument(Long.valueOf(fileId), processId);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    private <T, R> CountedResult<R> convertToDto(CountedResult<T> indicesCountedResult, Function<? super T, ? extends R> mapper) {
        List data = indicesCountedResult.getData().stream().map(mapper).collect(Collectors.toList());
        return new CountedResult(indicesCountedResult.getTotal(), data);
    }

    private Long getDocumentClassId(String documentClass) {
        DocumentClass docClass = this.documentClassService.getDocumentClass(documentClass, new String[0]);
        return docClass == null ? Long.parseLong(documentClass) : docClass.getId();
    }

    private WfDocument getWfDocument(AddBase64DocumentRequestDto requestDto, String newVersionMode, DocumentDefinition documentDefinition) throws Exception {
        WfDocument addedDocument;
        if (newVersionMode.equalsIgnoreCase("fileId") && requestDto.getNewVersionFileId() != null) {
            addedDocument = this.addNewDocumentVersion(requestDto.getNewVersionFileId(), documentDefinition);
        } else if (newVersionMode.equalsIgnoreCase("documentId") && requestDto.getNewVersionDocumentId() != null) {
            Long latestFileId = this.documentFinder.getDocument(requestDto.getNewVersionDocumentId(), Long.valueOf(requestDto.getDocumentClass())).getFile().getId();
            addedDocument = this.addNewDocumentVersion(latestFileId, documentDefinition);
        } else {
            addedDocument = this.addDocument(documentDefinition);
        }
        return addedDocument;
    }

    private WfDocument addNewDocumentVersion(Long fileId, DocumentDefinition documentDefinition) throws Exception {
        String currentDocState = this.fileService.getVersionForFile(fileId).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(fileId);
        }
        this.fileService.checkOut(fileId, documentDefinition.getUserName());
        long newestDocumentVersionId = this.fileService.checkIn(documentDefinition, fileId, "");
        return this.documentService.getDocument(Long.valueOf(newestDocumentVersionId));
    }

    private Long[] getFileIdsContainingDocumentClasses(Set<Long> fileIds, String[] documentClasses) {
        if (documentClasses == null || documentClasses.length == 0) {
            return fileIds.toArray(new Long[0]);
        }
        return (Long[])fileIds.stream().filter(fileId -> Arrays.stream(documentClasses).anyMatch(documentClass -> this.documentClassService.getDocumentClass(documentClass, new String[0]).getId().equals(this.documentService.getDocument(fileId).getDocumentClassId()))).toArray(Long[]::new);
    }

    private void changeDocumentClass(String processId, Long fileId, String targetDocumentClassString, Map<Long, Long> idPairs) {
        DocumentClass targetDocumentClass = this.documentClassService.getDocumentClass(targetDocumentClassString, new String[0]);
        try {
            WfDocument wfDocument = this.documentService.getDocument(fileId);
            if (!wfDocument.getDocumentClassId().equals(targetDocumentClass.getId())) {
                log.info("Working on file id: " + fileId);
                WfFile wfFile = this.fileService.getFile(Long.valueOf(wfDocument.getFile().getId()), new String[]{"version", "documentClass"});
                List<WfFile> wfFileAllVersion = this.getAllFileVersions(wfFile);
                try {
                    log.info("Creating a new document");
                    WfFile oneFile = wfFileAllVersion.get(wfFileAllVersion.size() - 1);
                    DocumentDefinition documentDefinition = this.createNewDocumentDefinition(targetDocumentClass, oneFile, processId, oneFile.getDocumentClass().getName());
                    WfDocument firstNewDoc = this.addDocument(documentDefinition);
                    Long tempDocId = firstNewDoc.getFile().getId();
                    for (int i = wfFileAllVersion.size() - 2; i >= 0; --i) {
                        log.info("Attaching document version");
                        tempDocId = this.addNextVersionDoc(processId, targetDocumentClass, DEFAULT_ADMINISTRATOR_USERNAME, wfFileAllVersion.get(i), tempDocId, oneFile.getDocumentClass().getName());
                    }
                    idPairs.put(wfDocument.getFile().getId(), firstNewDoc.getFile().getId());
                    log.info("Deleting document with id: " + wfDocument.getId() + " from class with id " + wfDocument.getDocumentClassId());
                    this.documentService.deleteAllDocumentVersions(wfDocument);
                }
                catch (Exception e) {
                    log.info("Incorrect file with id: " + wfDocument.getFile().getId());
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                idPairs.put(wfDocument.getFile().getId(), wfDocument.getFile().getId());
            }
        }
        catch (Exception e) {
            log.info("Incorrect file with id: " + fileId);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void changeDocumentIndexes(Long fileId, IndexMapDto[] indexes) {
        try {
            WfDocument wfDocument = this.documentService.getDocument(fileId);
            for (IndexMapDto indexMapDto : indexes) {
                if (indexMapDto.getIndexValue() == null) continue;
                wfDocument.setIndexValue(indexMapDto.getIndexName(), (Object)indexMapDto.getIndexValue());
            }
            this.documentService.updateDocument(wfDocument);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<WfFile> getAllFileVersions(WfFile wfFile) {
        ArrayList<WfFile> wfFileAllVersions = new ArrayList<WfFile>();
        while (wfFile != null) {
            wfFileAllVersions.add(wfFile);
            wfFile = wfFile.getVersion().getParentFile();
            wfFile = wfFile == null ? wfFile : this.fileService.getFile(Long.valueOf(wfFile.getId()), new String[]{"version", "documentClass"});
        }
        return wfFileAllVersions;
    }

    private WfDocument addDocument(DocumentDefinition documentDefinition) {
        return this.documentService.addDocument(documentDefinition);
    }

    private DocumentDefinition createNewDocumentDefinition(Long documentClassId, InputStream inputStream, String filename, String description, String username, String processId, String activityId, Boolean saveAsNewVersion, Map<Long, Object> indices) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(documentClassId);
        documentDefinition.setFileName(filename);
        documentDefinition.setUserName(username);
        documentDefinition.setInputStream(inputStream);
        documentDefinition.setSaveAsNewVersion(saveAsNewVersion.booleanValue());
        if (!indices.isEmpty()) {
            documentDefinition.setIndexes(indices);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            documentDefinition.setDescription(description);
        }
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            documentDefinition.setProcessId(processId);
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            documentDefinition.setActivityId(activityId);
        }
        return documentDefinition;
    }

    private DocumentDefinition createNewDocumentDefinition(DocumentClass targetDocumentClass, WfFile wfFile, String processId, String docClassSrc) {
        String description = wfFile.getDescription().equals(docClassSrc) ? targetDocumentClass.getName() : wfFile.getDescription();
        InputStream inputStream = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));
        return this.createNewDocumentDefinition(targetDocumentClass.getId(), inputStream, wfFile.getFileName(), description, wfFile.getUploader(), processId, null, false, Collections.emptyMap());
    }

    private Long addNextVersionDoc(String processId, DocumentClass targetDocumentClass, String userName, WfFile wfFile, Long tempDocId, String docClassSrc) throws Exception {
        this.fileService.checkOut(tempDocId, userName);
        DocumentDefinition fileDefinition = this.createNewDocumentDefinition(targetDocumentClass, wfFile, processId, docClassSrc);
        return this.fileService.checkIn(fileDefinition, tempDocId, wfFile.getVersion().getComment());
    }
}

