/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eventfunctions.servlets;

import com.suncode.plugin.eventfunctions.servlets.dto.DatasourceParamsRequestDto;
import com.suncode.pwfl.core.data.Record;
import com.suncode.pwfl.core.data.TableStore;
import com.suncode.pwfl.core.type.BasicTypes;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasources"})
public class DatasourceController {
    private static final Logger log = LoggerFactory.getLogger(DatasourceController.class);
    @Autowired
    private DataSourceService datasourceService;

    @RequestMapping(value={"execute"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public List<Map<String, Object>> executeDatasource(@RequestBody DatasourceParamsRequestDto request) {
        ImmutablePair<CountedResult<Map<String, Object>>, DataSourceInstance> result = this.executeDatasourceCommon(request);
        return ((CountedResult)result.getLeft()).getData();
    }

    private Map<String, String> getInputParametersMap(DataSourceInstance datasource, String[] datasourceInputParametersId, String[] datasourceInputParametersValue) {
        Set inputParameters = datasource.getInputParameters().stream().map(DataSourceParameter::getId).collect(Collectors.toSet());
        return IntStream.range(0, datasourceInputParametersId.length).boxed().filter(index -> datasourceInputParametersValue[index] != null && inputParameters.contains(datasourceInputParametersId[index])).collect(Collectors.toMap(index -> datasourceInputParametersId[index], i -> datasourceInputParametersValue[i], (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, LinkedHashMap::new));
    }

    @RequestMapping(value={"/v2/execute"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String executeDatasourceVer2(@RequestBody DatasourceParamsRequestDto request) {
        ImmutablePair<CountedResult<Map<String, Object>>, DataSourceInstance> result = this.executeDatasourceCommon(request);
        DataSourceInstance datasource = (DataSourceInstance)result.getRight();
        CountedResult countedData = (CountedResult)result.getLeft();
        TableStore tableStore = this.createTableStore(datasource.getOutputParameters(), countedData.getData());
        return tableStore.toJson();
    }

    private TableStore createTableStore(Set<DataSourceParameter> parameters, List<Map<String, Object>> data) {
        Map<String, BasicTypes> variableTypes = this.createVariableTypes(parameters);
        List<Record> recordData = this.createRecordData(data, variableTypes);
        return TableStore.builder().variableType(variableTypes).data(recordData).build();
    }

    private List<Record> createRecordData(List<Map<String, Object>> data, Map<String, BasicTypes> expectedKeyAndType) {
        ArrayList<Record> recordData = new ArrayList<Record>();
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> originalRecord = data.get(i);
            HashMap<String, Object> convertedRecord = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : originalRecord.entrySet()) {
                if (!expectedKeyAndType.containsKey(entry.getKey())) continue;
                Type type = expectedKeyAndType.get(entry.getKey()).getType();
                convertedRecord.put(entry.getKey(), this.convertValue(entry.getValue(), type, entry.getKey()));
            }
            recordData.add(new Record(convertedRecord));
        }
        return recordData;
    }

    private Object convertValue(Object value, Type type, String key) {
        if (type.isInstance(value)) {
            return value;
        }
        if (BasicTypes.STRING.getType() == type) {
            return value.toString();
        }
        log.warn(String.format("Invalid target type for field with id '%s', expected type: %s. Falling back to default value.", key, type.name()));
        return type.defaultValue();
    }

    private Map<String, BasicTypes> createVariableTypes(Set<DataSourceParameter> parameters) {
        HashMap<String, BasicTypes> variableTypes = new HashMap<String, BasicTypes>();
        for (DataSourceParameter parameter : parameters) {
            variableTypes.put(parameter.getId(), this.convertToBasicType(parameter.getType()));
        }
        return variableTypes;
    }

    private BasicTypes convertToBasicType(String type) {
        switch (type.toUpperCase()) {
            case "INTEGER": {
                return BasicTypes.INTEGER;
            }
            case "DECIMAL": {
                return BasicTypes.FLOAT;
            }
            case "BOOLEAN": {
                return BasicTypes.BOOLEAN;
            }
            case "DATE": {
                return BasicTypes.DATE;
            }
            case "DATETIME": {
                return BasicTypes.DATETIME;
            }
        }
        return BasicTypes.STRING;
    }

    private ImmutablePair<CountedResult<Map<String, Object>>, DataSourceInstance> executeDatasourceCommon(DatasourceParamsRequestDto request) {
        String[] datasourceInputParametersValue;
        String datasourceId = request.getDatasourceId();
        String[] datasourceInputParametersId = request.getDatasourceInputParametersId();
        Assert.isTrue((datasourceInputParametersId.length == (datasourceInputParametersValue = request.getDatasourceInputParametersValue()).length ? 1 : 0) != 0, (String)"Input parameters lists have different sizes!");
        DataSourceInstance datasource = this.datasourceService.getDataSource(datasourceId);
        Assert.notNull((Object)datasource, (String)"Chosen datasource does not exist!");
        Map<String, String> datasourceInputParameters = this.getInputParametersMap(datasource, datasourceInputParametersId, datasourceInputParametersValue);
        CountedResult countedData = datasource.execute(datasourceInputParameters, null);
        return new ImmutablePair((Object)countedData, (Object)datasource);
    }
}

