/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.autotasks;

import com.plusmpm.util.extension.P0047.db.P0047ConnectToDB;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Application
public class UpdateData {
    public static Logger log = Logger.getLogger(UpdateData.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ie.comment-process-app")).name("application.comment-process-app.name")).description("application.comment-process-app.desc")).category(new Category[]{Categories.TOOLS_FOR_PROCESS})).parameter().id("dateFrom").name("application.parameter.dateFrom.name").description("application.parameter.dateFrom.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("dateTo").name("application.parameter.dateTo.name").description("application.parameter.dateTo.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("employee").name("application.parameter.employee.name").description("application.parameter.employee.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("type").name("application.parameter.type.name").description("application.parameter.type.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("number").name("application.parameter.number.name").description("application.parameter.number.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create();
    }

    public void execute(@Param(value="dateFrom") String dateFrom, @Param(value="dateTo") String dateTo, @Param(value="employee") String employee, @Param(value="type") String type, @Param(value="number") String number, ApplicationContext appContext, UserInfo userInfo) {
        String[] details = this.getExecutorsDetails(number);
        log.debug((Object)("zapytania beda wykonywane na bazie danych: " + details[2]));
        String updateIds = this.getUpdateIdsList(dateFrom, dateTo, employee, details[2]);
        String sQuery = "update dbo.kp_kalendarz set typ = " + type + ", zmienial_kto = " + details[0] + ", zmienial_kiedy = (SELECT GETDATE()) where  id in (" + updateIds + ")";
        if (this.checkIfUpdate(type, updateIds, details[2])) {
            P0047ConnectToDB.P0047getDataFromExternalDB(details[2], sQuery);
            log.debug((Object)"przeprowadzamy aktualizacje");
        } else {
            log.debug((Object)"Brak aktualizacji z powodu niespelnionych warunkow");
        }
    }

    private String[] getExecutorsDetails(String number) {
        String[] details = new String[3];
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("SELECT id_kto_zmienial, id_firma, externalDBConfName from pm_idx_wniosek_urlopowy wu_p join pm_cust_przedsiebiorstwo wu_t on wu_p.przedsiebiorstwo = wu_t.przedsiebiorstwo where numer_wniosku = :company");
        builder.addScalar("id_firma", (Type)StandardBasicTypes.STRING);
        builder.addScalar("id_kto_zmienial", (Type)StandardBasicTypes.STRING);
        builder.addScalar("externalDBConfName", (Type)StandardBasicTypes.STRING);
        builder.setParameter("company", (Object)number);
        List data = finder.find(builder);
        if (!data.isEmpty()) {
            details[0] = (String)((Map)data.get(0)).get("id_kto_zmienial");
            details[1] = (String)((Map)data.get(0)).get("id_firma");
            details[2] = (String)((Map)data.get(0)).get("externalDBConfName");
        }
        return details;
    }

    private String getUpdateIdsList(String dateFrom, String dateTo, String user, String externalDBConf) {
        String sResult = "";
        int liczbaDniUrlopu = this.getDifferenceBetweenDates(dateFrom, dateTo);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < liczbaDniUrlopu; ++i) {
            String sId = this.getRowId(user, this.getDateDetails(dateFrom, i), externalDBConf);
            log.debug((Object)sId);
            if (StringUtils.isBlank((CharSequence)sId)) continue;
            sb.append(sId);
            sb.append(",");
        }
        sResult = sb.toString();
        log.debug((Object)("lista id do zmiany: " + sResult));
        sResult = this.checkAndRemoveComma(sResult);
        return sResult;
    }

    private int getDifferenceBetweenDates(String dateFrom, String dateTo) {
        int diff = 0;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        LocalDateTime dateTime1 = LocalDateTime.parse((String)dateFrom, (DateTimeFormatter)formatter);
        LocalDateTime dateTime2 = LocalDateTime.parse((String)dateTo, (DateTimeFormatter)formatter);
        diff = Days.daysBetween((ReadablePartial)dateTime1, (ReadablePartial)dateTime2).getDays() + 1;
        log.debug((Object)("liczba dni urlopu: " + diff));
        return diff;
    }

    private String getRowId(String user, int[] deteDetails, String externalDBConf) {
        ArrayList<HashMap<String, String>> list = null;
        String typ = "";
        String sQuery = "select id from dbo.kp_kalendarz where typ is not null and rok = " + deteDetails[0] + " and miesiac = " + deteDetails[1] + " and dzien = " + deteDetails[2] + " and osoba = " + user;
        log.debug((Object)sQuery);
        list = P0047ConnectToDB.P0047getDataFromExternalDB(externalDBConf, sQuery);
        if (!list.isEmpty()) {
            typ = list.get(0).get("id");
        }
        return typ;
    }

    private int[] getDateDetails(String date, int period) {
        DateTime dateTime = new DateTime((Object)date);
        dateTime = dateTime.plusDays(period);
        int[] details = new int[]{dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth()};
        return details;
    }

    private String checkAndRemoveComma(String text) {
        String sResult = text;
        if (StringUtils.equals((CharSequence)text.substring(text.length() - 1), (CharSequence)",")) {
            sResult = text.substring(0, text.length() - 1);
            log.debug((Object)("lista po usunieciu przecinka " + sResult));
        }
        return sResult;
    }

    private boolean checkIfUpdate(String type, String updateIds, String externalDBConf) {
        ArrayList<HashMap<String, String>> list = null;
        boolean bResult = true;
        String wynik = "";
        Object sQuery = "";
        sQuery = StringUtils.equals((CharSequence)type, (CharSequence)"1") ? "select count(typ) as wynik from dbo.kp_kalendarz where typ is not null and typ != 2 and id in (" + updateIds + ")" : "select count(typ) as wynik from dbo.kp_kalendarz where typ is not null and typ != 1 and id in (" + updateIds + ")";
        log.debug(sQuery);
        list = P0047ConnectToDB.P0047getDataFromExternalDB(externalDBConf, (String)sQuery);
        if (!list.isEmpty()) {
            wynik = list.get(0).get("wynik");
        }
        if (!StringUtils.equals((CharSequence)wynik, (CharSequence)"0")) {
            bResult = false;
        }
        return bResult;
    }
}

