/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0047.db;

import com.plusmpm.CUF.database.externalDBConf.ExternalDBConf;
import com.plusmpm.CUF.database.externalDBConf.ExternalDBConfManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class P0047ConnectToDB {
    private static Logger log = Logger.getLogger(P0047ConnectToDB.class);

    public static ArrayList<HashMap<String, String>> P0047getDataFromExternalDB(String conName, String query) {
        ArrayList<HashMap<String, String>> list = null;
        List conf = null;
        try {
            conf = ExternalDBConfManager.getExternalDBConfForName((String)conName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
        if (conf != null) {
            try {
                Connection con = P0047ConnectToDB.connectToExternalDB((ExternalDBConf)conf.get(0));
                list = P0047ConnectToDB.executeQuery(con, query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Connection connectToExternalDB(ExternalDBConf conParamsList) throws Exception {
        Connection con = null;
        String url = conParamsList.getUrl();
        String driver = conParamsList.getDriver();
        String login = conParamsList.getLogin();
        String password = conParamsList.getPassword();
        try {
            if (driver != null) {
                Class.forName(driver);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Niepoprawny sterownik");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            con = DriverManager.getConnection(url, login, password);
            if (!con.isClosed() && con != null) {
                log.info((Object)("Uzyskano polaczenie z " + url));
                return con;
            }
            log.error((Object)"Brak polaczenia z zewnetrzna baza danych");
            throw new Exception("Nie mo\u0139\u013dna nawiazac polaczenia z baza");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static ArrayList<HashMap<String, String>> executeQuery(Connection con, String query) throws Exception {
        log.trace((Object)("************************* executeQuery(Connection, query=" + query + ") ********************"));
        ArrayList<HashMap<String, String>> results = null;
        ResultSet rset = null;
        try (Statement stmt = null;){
            results = new ArrayList<HashMap<String, String>>();
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania: " + query));
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            rset = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rset.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rset.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String value = rset.getString(columnName);
                    if (value == null) {
                        value = "";
                    }
                    oneRow.put(columnName, value);
                }
                results.add(oneRow);
            }
            log.debug((Object)("Ilosc zwroconych wynikow: " + results.size()));
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania: " + (dtEnd.getTime() - dtStart.getTime())));
            ArrayList<HashMap<String, String>> arrayList = results;
            return arrayList;
        }
    }
}

