Ext.ux.suncode.PermissionsTable = function( config ) {
    config = config ? config : new Object();
    var record = Ext.data.Record.create( [ {
        name: 'id',
        type: 'int'
    }, {
        name: 'scope',
        type: 'string'
    }, {
        name: 'value',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: Suncode.context( 'efaktura' ).pluginContextPath + '/api/permission/get'
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoLoad: true,
        autoDestroy: true,
        batch: true,
        remoteSort: true,
        sortInfo: {
            field: 'scope',
            direction: 'ASC'
        },
        fields: record,
        root: 'data',
        totalProperty: 'total',
        baseParams: {
            start: 0,
            limit: 50
        }
    } );

    var scopesChooser = new Ext.ux.suncode.PermissionScopesChooser();

    config = Ext.apply( {
        itemId: 'permission-table',
        region: 'center',
        store: store,
        columnLines: true,
        autoScroll: true,
        enableColumnMove: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                dataIndex: 'id',
                hidden: true,
                hideable: false
            }, {
                id: 'scope',
                header: getTranslation( 'Zakres uprawnienia' ),
                dataIndex: 'scope',
                renderer: Ext.util.Format.ComboBoxRenderer( scopesChooser )
            }, {
                id: 'value',
                header: getTranslation( 'Wartość uprawnienia' ),
                dataIndex: 'value'
            } ]
        } ),
        loadMask: {
            msg: getTranslation( 'Trwa ładowanie danych...' )
        },
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak uprawnień' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj uprawnienie' ),
                scope: this,
                handler: this.addPermission
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń uprawnienie' ),
                scope: this,
                handler: this.deletePermission
            } ]
        } ),
        bbar: new Ext.ux.suncode.StandardPagingToolbar( {
            pageSize: 20,
            store: store,
            contentName: getTranslation( 'Uprawnienia' ),
            emptyMsg: getTranslation( 'Brak uprawnień' )
        } )
    }, config );

    Ext.ux.suncode.PermissionsTable.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PermissionsTable, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.PermissionsTable.superclass.initComponent.call( this );
    },
    filter: function( filter ) {
        var store = this.getStore();

        Ext.iterate( filter, function( key, value, object ) {
            store.setBaseParam( key, value );
        } );

        this.refresh();
    },
    refresh: function() {
        var store = this.getStore();
        store.reload();
    },
    addPermission: function() {
        var win = new Ext.ux.suncode.AddPermissionWindow( {
            permissionTable: this
        } );
        win.show();
    },
    deletePermission: function() {
        var selModel = this.getSelectionModel();
        var rows = selModel.getSelections();

        if ( rows.length == 0 ) {
            showWarn( getTranslation( 'Wybierz uprawnienie do usunięcia.' ) );
        } else {
            var permission = rows[0];

            Ext.Ajax.request( {
                url: Suncode.context( 'efaktura' ).pluginContextPath + '/api/permission/delete/' + permission.get( 'id' ),
                method: 'DELETE',
                scope: this,
                success: function( response, opts ) {
                    var result = Ext.util.JSON.decode( response.responseText ).data;

                    if ( result.executed ) {
                        removeRowAndMarkNext( this, permission );
                        this.refresh();
                    } else {
                        showWarn( getTranslation( result.executionError ) );
                    }
                },
                failure: function( response, opts ) {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            } );
        }
    }
} );