/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.rest;

import com.google.gson.Gson;
import com.plusmpm.util.Authorization;
import com.suncode.plugin.efaktura.service.module.ScriptService;
import com.suncode.plugin.efaktura.service.module.StyleService;
import com.suncode.plugin.efaktura.web.support.dto.AdministrationConfigurationDto;
import com.suncode.plugin.efaktura.web.support.dto.ScriptDto;
import com.suncode.plugin.efaktura.web.support.dto.StyleDto;
import com.suncode.plugin.efaktura.web.support.util.RestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jooq.tools.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ViewController {
    @Autowired
    private StyleService styleService;
    @Autowired
    private ScriptService scriptService;

    @RequestMapping(value={"configuration"})
    public String configuration(HttpServletRequest request) {
        request.setAttribute("lang", (Object)LocaleContextHolder.getLocale().getLanguage());
        return "configuration";
    }

    @RequestMapping(value={"administration"})
    public ModelAndView administration(HttpServletRequest request) {
        String userId = RestUtils.getUserIdFromSession(request);
        if (this.hasAdminRights(userId)) {
            ModelAndView modelAndView = new ModelAndView("administration");
            modelAndView.addObject("styles", this.buildAdministrationStyles());
            modelAndView.addObject("scripts", this.buildAdministrationScripts());
            modelAndView.addObject("configuration", (Object)this.buildAdministrationConfigurationAsString());
            return modelAndView;
        }
        return this.buildUnauthorizedView();
    }

    private boolean hasAdminRights(String userId) {
        try {
            int right = Authorization.checkRight((String)"system.admin", (String)userId, (boolean)false, (boolean)false);
            return right == 0;
        }
        catch (SQLException exception) {
            return false;
        }
    }

    private List<StyleDto> buildAdministrationStyles() {
        return this.styleService.getAllForAdministration();
    }

    private List<ScriptDto> buildAdministrationScripts() {
        return this.scriptService.getAllForAdministration();
    }

    private String buildAdministrationConfigurationAsString() {
        AdministrationConfigurationDto dto = new AdministrationConfigurationDto();
        dto.setLanguage(ViewController.getLanguage());
        Gson gson = new Gson();
        String json = gson.toJson((Object)dto);
        return JSONObject.escape((String)json);
    }

    public static String getLanguage() {
        Locale locale = LocaleContextHolder.getLocale();
        return locale.getLanguage();
    }

    private ModelAndView buildUnauthorizedView() {
        ModelAndView modelAndView = new ModelAndView("unauthorized");
        modelAndView.addObject("unauthorizedMessage", (Object)"401 Unauthorized");
        return modelAndView;
    }
}

