/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.rest;

import com.suncode.plugin.efaktura.service.permission.PermissionService;
import com.suncode.plugin.efaktura.util.PageResult;
import com.suncode.plugin.efaktura.util.PagingInfo;
import com.suncode.plugin.efaktura.util.PermissionFilter;
import com.suncode.plugin.efaktura.web.support.dto.PermissionDto;
import com.suncode.plugin.efaktura.web.support.dto.PermissionOperationDto;
import com.suncode.plugin.efaktura.web.support.util.CountedResult;
import com.suncode.plugin.efaktura.web.support.util.PermissionDataResult;
import com.suncode.plugin.efaktura.web.support.util.RestUtils;
import com.suncode.plugin.efaktura.web.support.util.SortInfo;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/permission"})
public class PermissionController {
    @Autowired
    private PermissionService permissionService;

    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<PermissionDto> get(PermissionFilter filter, PagingInfo pagingInfo, SortInfo sortInfo) {
        PageResult<PermissionDto> pageResult = this.permissionService.get(filter, pagingInfo.getStart(), pagingInfo.getLimit(), sortInfo.getSort(), sortInfo.getDir());
        return new CountedResult<PermissionDto>(pageResult.getPage(), pageResult.getTotal());
    }

    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    @ResponseBody
    public PermissionDataResult<PermissionOperationDto> add(HttpServletRequest request, PermissionDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        PermissionOperationDto permissionOperationDto = this.permissionService.add(userId, dto);
        return new PermissionDataResult<PermissionOperationDto>(true, permissionOperationDto);
    }

    @RequestMapping(value={"delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public PermissionDataResult<PermissionOperationDto> delete(HttpServletRequest request, @PathVariable Long id) {
        String userId = RestUtils.getUserIdFromSession(request);
        PermissionOperationDto permissionOperationDto = this.permissionService.delete(userId, id);
        return new PermissionDataResult<PermissionOperationDto>(true, permissionOperationDto);
    }
}

