/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.emailtopdf;

import com.suncode.plugin.efaktura.configuration.EfakturaSpringContext;
import com.suncode.plugin.efaktura.docxtopdf.DocxTemplateToPdfConverter;
import com.suncode.plugin.efaktura.docxtopdf.VariablesPreparator;
import com.suncode.plugin.efaktura.service.plugin.PluginService;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import com.suncode.plugin.efaktura.util.ClassLoaderUtils;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.Workaround;
import com.suncode.plugin.efaktura.util.emailtopdf.Email;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailBuilderImpl;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPart;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailProperty;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailToPdfConverter;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailToPdfMapping;
import com.suncode.plugin.efaktura.util.emailtopdf.HtmlPartExtractorImpl;
import com.suncode.plugin.efaktura.util.xhtml.EfakturaXHTMLImporterImpl;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.springframework.core.io.Resource;

public class EmailToPdfConverterImpl
implements EmailToPdfConverter {
    public static Logger log = Logger.getLogger(EmailToPdfConverterImpl.class);
    private static final String DEFAULT_TEMPLATE_PATH = "/templates/mail-as-pdf.docx";
    private static final String DEFAULT_SIMPLE_TEMPLATE_PATH = "/templates/simple-mail-as-pdf.docx";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String IMAGE_CONTENT_TYPE_PREFIX = "image";
    private static final String JOINER = "; ";
    private static final String NEW_LINE = "</w:t><w:br></w:br><w:t>";
    private static final String FILE_EXTENSION = "pdf";

    @Override
    public File convert(Message message, AdditionalOptions additionalOptions) {
        try {
            List<WordprocessingMLPackage> templates = this.getDocxTemplates(additionalOptions);
            Email email = this.buildEmail(message);
            EmailToPdfMapping mappings = this.buildMappings(email);
            for (WordprocessingMLPackage template : templates) {
                File file = this.convert(email, template, mappings, additionalOptions);
                if (file == null) continue;
                return file;
            }
            return null;
        }
        catch (Throwable exception) {
            log.error((Object)exception.getMessage(), exception);
            return null;
        }
    }

    private List<WordprocessingMLPackage> getDocxTemplates(AdditionalOptions additionalOptions) throws Exception {
        ArrayList<WordprocessingMLPackage> templates = new ArrayList<WordprocessingMLPackage>();
        templates.add(this.getDocxTemplate(additionalOptions));
        templates.add(this.getSimpleDocxTemplate());
        return templates;
    }

    private WordprocessingMLPackage getDocxTemplate(AdditionalOptions additionalOptions) throws Exception {
        String templatePath = additionalOptions.getMailAsPdfTemplatePath();
        File templateFile = new File(templatePath);
        if (templateFile.exists()) {
            return this.getTemplate(templateFile);
        }
        PluginService pluginService = EfakturaSpringContext.getBean(PluginService.class);
        Resource resource = pluginService.getResource(DEFAULT_TEMPLATE_PATH);
        return this.getTemplate(resource);
    }

    private WordprocessingMLPackage getTemplate(File templateFile) throws Exception {
        WordprocessingMLPackage template = WordprocessingMLPackage.load((File)templateFile);
        return this.prepareTemplate(template);
    }

    private WordprocessingMLPackage prepareTemplate(WordprocessingMLPackage template) throws Exception {
        this.prepareVariables((JaxbXmlPartXPathAware)template.getMainDocumentPart());
        VariablePrepare.prepare((WordprocessingMLPackage)template);
        return template;
    }

    private <T> void prepareVariables(JaxbXmlPartXPathAware<T> element) {
        VariablesPreparator preparator = EfakturaSpringContext.getBean(VariablesPreparator.class);
        preparator.prepare(element);
    }

    private WordprocessingMLPackage getTemplate(Resource resource) throws Exception {
        WordprocessingMLPackage template = WordprocessingMLPackage.load((InputStream)resource.getInputStream());
        return this.prepareTemplate(template);
    }

    private WordprocessingMLPackage getSimpleDocxTemplate() throws Exception {
        PluginService pluginService = EfakturaSpringContext.getBean(PluginService.class);
        Resource resource = pluginService.getResource(DEFAULT_SIMPLE_TEMPLATE_PATH);
        return this.getTemplate(resource);
    }

    private Email buildEmail(Message message) throws MessagingException, IOException {
        EmailBuilderImpl builder = new EmailBuilderImpl();
        return builder.build(message);
    }

    private EmailToPdfMapping buildMappings(Email email) throws MessagingException, IOException {
        EmailToPdfMapping mappings = new EmailToPdfMapping();
        mappings.addValue(EmailProperty.SUBJECT, this.formatValueForXml(email.getSubject()));
        mappings.addValue(EmailProperty.FROM, this.formatValueForXml(email.getFrom()));
        mappings.addValue(EmailProperty.TO, this.formatValueForXml(email.getTo()));
        mappings.addValue(EmailProperty.CC, this.formatValueForXml(email.getCc()));
        mappings.addValue(EmailProperty.BCC, this.formatValueForXml(email.getBcc()));
        mappings.addValue(EmailProperty.RECIPIENTS, this.formatValueForXml(email.getRecipients()));
        mappings.addValue(EmailProperty.SENT_DATE, email.getSentDate());
        mappings.addValue(EmailProperty.RECEIVED_DATE, email.getReceivedDate());
        mappings.addValue(EmailProperty.SIMPLE_CONTENTS, this.formatContentsForXml(email.getSimpleContents()));
        mappings.addValue(EmailProperty.CONTENTS, this.formatContentsForXml(email.getSimpleContents()));
        mappings.addValue(EmailProperty.ATTACHMENTS, StringUtils.join(email.getAttachments(), (String)JOINER));
        mappings.addValue(EmailProperty.ATTACHMENTS_LIST, StringUtils.join(email.getAttachments(), (String)NEW_LINE));
        return mappings;
    }

    private String formatValueForXml(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    private String formatContentsForXml(String contents) {
        String formattedContents = this.formatValueForXml(contents);
        formattedContents = StringUtils.replace((String)formattedContents, (String)"\r", (String)"");
        formattedContents = StringUtils.replace((String)formattedContents, (String)"\n", (String)NEW_LINE);
        return formattedContents;
    }

    private File convert(Email email, WordprocessingMLPackage template, EmailToPdfMapping mappings, AdditionalOptions additionalOptions) {
        try {
            this.fillContents(email, template, additionalOptions);
            return this.convertTemplateToPdf(template, mappings, additionalOptions);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void fillContents(Email email, WordprocessingMLPackage template, AdditionalOptions additionalOptions) throws Exception {
        ClassLoaderUtils.doInContextClassLoader(() -> this.setXhtmlContents(email, template, additionalOptions));
    }

    private void setXhtmlContents(Email email, WordprocessingMLPackage template, AdditionalOptions additionalOptions) throws Exception {
        EmailPart htmlPart = this.getHtmlPart(email);
        List<Object> contentsNodes = this.getContentsNodes(template);
        if (htmlPart != null && CollectionUtils.isNotEmpty(contentsNodes)) {
            String html = this.extractHtmlFromPart(htmlPart, additionalOptions);
            List<EmailPart> imageParts = this.getImagePart(email);
            for (EmailPart imagePart : imageParts) {
                String inlineImage = this.buildInlineImage(imagePart, additionalOptions);
                String cid = this.buildCid(imagePart);
                html = StringUtils.replace((String)html, (String)cid, (String)inlineImage);
            }
            EfakturaXHTMLImporterImpl xhtmlImporter = new EfakturaXHTMLImporterImpl(template);
            List list = xhtmlImporter.convert(html, null);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (Object node : contentsNodes) {
                    int index;
                    Object container;
                    if (!(node instanceof P)) continue;
                    P paragraph = (P)node;
                    Object parent = paragraph.getParent();
                    if (parent instanceof ContentAccessor) {
                        container = (ContentAccessor)parent;
                        index = container.getContent().indexOf(node);
                        container.getContent().remove(index);
                        for (Object object : list) {
                            container.getContent().add(index, object);
                            ++index;
                        }
                        continue;
                    }
                    if (!(parent instanceof List)) continue;
                    container = (List)parent;
                    index = container.indexOf(paragraph);
                    container.remove(index);
                    for (Object object : list) {
                        container.add(index, object);
                        ++index;
                    }
                }
            }
        }
    }

    private EmailPart getHtmlPart(Email email) {
        if (CollectionUtils.isNotEmpty(email.getParts())) {
            for (EmailPart part : email.getParts()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)part.getDisposition(), (CharSequence)"attachment") || !StringUtils.equalsIgnoreCase((CharSequence)part.getContentType(), (CharSequence)HTML_CONTENT_TYPE)) continue;
                return part;
            }
        }
        return null;
    }

    private List<Object> getContentsNodes(WordprocessingMLPackage template) throws JAXBException, XPathBinderAssociationIsPartialException {
        String xpath = this.buildContentsNodesXpath();
        MainDocumentPart documentPart = template.getMainDocumentPart();
        return documentPart.getJAXBNodesViaXPath(xpath, false);
    }

    private String buildContentsNodesXpath() {
        StringBuilder xpath = new StringBuilder();
        xpath.append("//w:p[w:r[w:t[contains(text(),'${");
        xpath.append(EmailProperty.CONTENTS.getName());
        xpath.append("}')]]]");
        return xpath.toString();
    }

    private String extractHtmlFromPart(EmailPart part, AdditionalOptions additionalOptions) throws IOException {
        HtmlPartExtractorImpl extractor = new HtmlPartExtractorImpl();
        return extractor.extract(part, additionalOptions);
    }

    private List<EmailPart> getImagePart(Email email) {
        ArrayList<EmailPart> parts = new ArrayList<EmailPart>();
        if (CollectionUtils.isNotEmpty(email.getParts())) {
            for (EmailPart part : email.getParts()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)part.getDisposition(), (CharSequence)"attachment") || !StringUtils.startsWith((CharSequence)part.getContentType(), (CharSequence)IMAGE_CONTENT_TYPE_PREFIX)) continue;
                parts.add(part);
            }
        }
        return parts;
    }

    private String buildInlineImage(EmailPart part, AdditionalOptions additionalOptions) throws IOException {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Workaround.imapMessageNumberOutOfBounds(additionalOptions.getFolder());
            bytes = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        byte[] encodedBytes = Base64.encodeBase64((byte[])bytes, (boolean)false);
        String encodedImage = new String(encodedBytes, Charset.forName("UTF-8"));
        StringBuilder image = new StringBuilder();
        image.append("data:");
        image.append(part.getContentType());
        image.append(";base64,");
        image.append(encodedImage);
        return image.toString();
    }

    private String buildCid(EmailPart part) {
        StringBuilder cid = new StringBuilder();
        cid.append("cid:");
        cid.append(part.getContentId());
        return cid.toString();
    }

    private File convertTemplateToPdf(WordprocessingMLPackage template, EmailToPdfMapping mappings, AdditionalOptions additionalOptions) throws Exception {
        byte[] bytes = this.convertTemplateToPdf(template, mappings, additionalOptions.getMailAsPdfDocxToPdfConverterType());
        if (ArrayUtils.isNotEmpty((byte[])bytes)) {
            return PlusEFakturaTools.saveBytesToFile(additionalOptions.getDirPathForTempFile(), FILE_EXTENSION, bytes);
        }
        return null;
    }

    private byte[] convertTemplateToPdf(WordprocessingMLPackage template, EmailToPdfMapping mappings, String converterType) {
        DocxTemplateToPdfConverter converter = EfakturaSpringContext.getBean(DocxTemplateToPdfConverter.class);
        return converter.convert(template, mappings, converterType);
    }
}

