/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.util.AttachmentActionType;
import com.suncode.plugin.efaktura.util.AttachmentDetectionType;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Validator {
    private Validator() {
    }

    public static boolean hasEmails(String[] emails) {
        return !ArrayUtils.isEmpty((Object[])emails) && (ArrayUtils.getLength((Object)emails) != 1 || !StringUtils.isBlank((CharSequence)emails[0]));
    }

    public static boolean hasEmails(List<String> emails) {
        return !CollectionUtils.isEmpty(emails) && (CollectionUtils.size(emails) != 1 || !StringUtils.isBlank((CharSequence)emails.get(0)));
    }

    public static boolean hasNoDuplications(List<String> emails) {
        return emails.stream().allMatch(new HashSet()::add);
    }

    public static boolean isValidEmail(String email) {
        return email.split("@").length == 2;
    }

    public static boolean isPhraseValid(String phrase, TemplatePhraseLocation location) {
        return !(StringUtils.isNotBlank((CharSequence)phrase) && location == null || StringUtils.isBlank((CharSequence)phrase) && location != TemplatePhraseLocation.UNKNOWN);
    }

    public static boolean isAttachmentDetectionValid(String detectionType, String detectionValue) {
        switch (AttachmentDetectionType.getByName(detectionType)) {
            case PHRASE_IN_FILE_NAME: 
            case PHRASE_IN_CONTENT: {
                return !StringUtils.isBlank((CharSequence)detectionValue);
            }
        }
        return true;
    }

    public static boolean isAttachmentActionValid(String actionType, String actionValue) {
        switch (AttachmentActionType.getByName(actionType)) {
            case ADD_TO_DOCUMENT_CLASS: {
                return !StringUtils.isBlank((CharSequence)actionValue);
            }
        }
        return true;
    }
}

