/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.upgrader;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.plugin.efaktura.configuration.EfakturaSpringContext;
import com.suncode.plugin.efaktura.service.permission.PermissionService;
import com.suncode.plugin.efaktura.util.PermissionScope;
import com.suncode.plugin.efaktura.web.support.dto.PermissionDto;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.util.SpringContext;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class MigrateConfigurationPermissionsChange
implements CustomTaskChange {
    private static final String EFAKTURA_PROCESS_DEF_ID = "pefaktura";

    public void execute(Database database) throws CustomChangeException {
        PermissionService permissionService = EfakturaSpringContext.getBean(PermissionService.class);
        UserGroupFinder userGroupFinder = (UserGroupFinder)SpringContext.getBean(UserGroupFinder.class);
        UserFinder userFinder = (UserFinder)SpringContext.getBean(UserFinder.class);
        userGroupFinder.getAll(new String[0]).stream().map(UserGroup::getName).filter(groupName -> this.hasRightsToCreateProcess((String)groupName, true)).forEach(groupName -> MigrateConfigurationPermissionsChange.addPermission(permissionService, PermissionScope.GROUP, groupName));
        userFinder.getAll(new String[0]).stream().map(User::getUserName).filter(userName -> this.hasRightsToCreateProcess((String)userName, false)).forEach(userName -> MigrateConfigurationPermissionsChange.addPermission(permissionService, PermissionScope.USER, userName));
    }

    private boolean hasRightsToCreateProcess(String resourceId, boolean isGroup) {
        return Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)EFAKTURA_PROCESS_DEF_ID).build(), (String)resourceId, (boolean)isGroup, (boolean)true) == 0;
    }

    private static void addPermission(PermissionService permissionService, PermissionScope permissionScope, String userId) {
        PermissionDto dto = new PermissionDto();
        dto.setScope(permissionScope.getName());
        dto.setValue(userId);
        permissionService.add(userId, dto);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

