/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.template;

import com.suncode.plugin.efaktura.dao.template.EmailFromDao;
import com.suncode.plugin.efaktura.dao.template.TemplateDao;
import com.suncode.plugin.efaktura.i18n.TranslatorService;
import com.suncode.plugin.efaktura.model.template.EmailFrom;
import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.model.template.TemplateDefinition;
import com.suncode.plugin.efaktura.service.template.TemplateValidator;
import com.suncode.plugin.efaktura.util.TemplateFilter;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import com.suncode.plugin.efaktura.web.support.dto.EmailFromDto;
import com.suncode.plugin.efaktura.web.support.dto.PhraseLocationDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDownloadDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TemplateService {
    private static final String TEMPLATE_ID_INDEX_NAME = "Identyfikator szablonu";
    private static final String DEFAULT_TEMPLATE_DOCUMENT_CLASS_NAME = "Plus E-faktura Templates";
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private EmailFromDao emailFromDao;
    @Autowired
    private TemplateValidator templateValidator;
    @Autowired
    private TranslatorService translatorService;

    @Transactional
    public void add(String userId, List<String> emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation, Integer priority, MultipartFile file) throws IOException {
        DocumentClass templateDocumentClass = TemplateService.getTemplateDocumentClass();
        if (templateDocumentClass == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.application.add-email.status.doc-class-does-not-exist"));
        }
        this.templateValidator.validateAdd(emailsFrom, emailTo, phrase, phraseLocation, priority);
        WfDocument wfDocument = this.addTemplateAsDocument(userId, templateDocumentClass, file);
        Long fileId = wfDocument.getFile().getId();
        TemplateDefinition templateDefinition = new TemplateDefinition();
        templateDefinition.setName("template_" + System.nanoTime());
        templateDefinition.setFileId(fileId);
        templateDefinition.setPriority(priority);
        templateDefinition.setPhrase(phrase);
        templateDefinition.setPhraseLocation(phraseLocation);
        Template template = new Template();
        template.setEmailTo(emailTo);
        template.setTemplateDefinition(templateDefinition);
        emailsFrom.stream().map(EmailFrom::new).forEach(template::addEmailFrom);
        long addedTemplateId = this.add(template);
        this.updateTemplateIndexes(wfDocument, addedTemplateId, emailsFrom, emailTo, phrase, phraseLocation, priority);
    }

    @Transactional
    public void add(List<String> emailsFrom, String emailTo) {
        this.templateValidator.validateSimpleAdd(emailsFrom, emailTo);
        TemplateDefinition templateDefinition = new TemplateDefinition();
        templateDefinition.setName("template_" + System.currentTimeMillis());
        templateDefinition.setFileId(-1L);
        templateDefinition.setPriority(1);
        templateDefinition.setPhrase("");
        Template template = new Template();
        template.setEmailTo(emailTo);
        template.setTemplateDefinition(templateDefinition);
        emailsFrom.stream().map(EmailFrom::new).forEach(template::addEmailFrom);
        this.add(template);
    }

    @Transactional
    public long add(Template template) {
        return (Long)this.templateDao.save(template);
    }

    @Transactional
    public void edit(Long id, String userId, List<String> emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation, Integer priority, MultipartFile file) throws IOException {
        DocumentClass templateDocumentClass = TemplateService.getTemplateDocumentClass();
        if (templateDocumentClass == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.application.add-email.status.doc-class-does-not-exist"));
        }
        this.templateValidator.validateUpdate(id, emailsFrom, emailTo, phrase, phraseLocation);
        Template template = this.getById(id);
        if (file != null) {
            WfDocument wfDocument = this.addTemplateAsDocument(userId, templateDocumentClass, file);
            Long fileId = wfDocument.getFile().getId();
            template.getTemplateDefinition().setFileId(fileId);
        } else {
            Long fileId = template.getTemplateDefinition().getFileId();
            DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
            WfDocument wfDocument = documentFinder.findByFileId(fileId, templateDocumentClass.getId());
            if (Objects.nonNull(wfDocument)) {
                this.updateTemplateIndexes(wfDocument, id, emailsFrom, emailTo, phrase, phraseLocation, priority);
            }
        }
        this.editEmailsFrom(emailsFrom, template);
        template.setEmailTo(emailTo);
        template.getTemplateDefinition().setPhrase(phrase);
        template.getTemplateDefinition().setPhraseLocation(phraseLocation);
        template.getTemplateDefinition().setPriority(priority);
        this.edit(template);
    }

    private void editEmailsFrom(List<String> emailsFrom, Template template) {
        ArrayList<String> emailsFromList = new ArrayList<String>(emailsFrom);
        Iterator<EmailFrom> iterator = template.getEmailsFrom().iterator();
        while (iterator.hasNext()) {
            EmailFrom emailFrom = iterator.next();
            if (emailsFromList.remove(emailFrom.getEmailFrom())) continue;
            iterator.remove();
        }
        emailsFromList.stream().map(EmailFrom::new).forEach(template::addEmailFrom);
    }

    @Transactional
    public void editWithoutFile(Long id, List<String> emailsFrom, String emailTo) throws IOException {
        this.templateValidator.validateSimpleUpdate(id, emailsFrom, emailTo);
        Template template = this.getById(id);
        this.editEmailsFrom(emailsFrom, template);
        template.setEmailTo(emailTo);
        this.edit(template);
    }

    private WfDocument addTemplateAsDocument(String userId, DocumentClass templateDocumentClass, MultipartFile file) throws IOException {
        DocumentService documentService = ServiceFactory.getDocumentService();
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(templateDocumentClass.getId());
        definition.setDescription(templateDocumentClass.getName());
        definition.setFileName(file.getOriginalFilename());
        definition.setUserName(userId);
        definition.setInputStream(file.getInputStream());
        definition.setIndexes(new HashMap());
        definition.setSaveAsNewVersion(false);
        return documentService.addDocument(definition);
    }

    private void updateTemplateIndexes(WfDocument wfDocument, Long templateId, List<String> emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation, Integer priority) {
        HashMap<Long, Object> values = new HashMap<Long, Object>();
        for (IndexInfo oneIndex : wfDocument.getIndexes()) {
            Long id = oneIndex.getId();
            String indexName = oneIndex.getName();
            if (StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)"Email dostawcy")) {
                values.put(id, StringUtils.join(emailsFrom, (String)";"));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)"Email odbiorcy")) {
                values.put(id, emailTo);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)"Fraza")) {
                values.put(id, phrase);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)"Wyst\u0105pienie frazy")) {
                values.put(id, Optional.ofNullable(phraseLocation).map(Enum::toString).orElse(""));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)"Priorytet")) {
                values.put(id, Long.valueOf(String.valueOf(priority)));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)indexName, (CharSequence)TEMPLATE_ID_INDEX_NAME)) continue;
            values.put(id, templateId);
        }
        Long fileId = wfDocument.getFile().getId();
        FileService fileService = (FileService)SpringContext.getBean(FileService.class);
        fileService.changeFileIndexes(fileId, values);
    }

    @Transactional
    public void edit(Template template) {
        this.templateDao.update(template);
    }

    @Transactional
    public void remove(Template template) {
        this.templateDao.delete(template);
    }

    @Transactional(readOnly=true)
    public Optional<Template> find(TemplateFilter filter) {
        return this.templateDao.find(filter);
    }

    @Transactional(readOnly=true)
    public CountedResult<TemplateDto> findAll(TemplateFilter filter, Integer start, Integer limit) {
        CountedResult<Template> result = this.templateDao.findAll(filter, start, limit);
        return new CountedResult(result.getTotal(), result.getData().stream().map(TemplateService::toTemplateDto).collect(Collectors.toList()));
    }

    @Transactional(readOnly=true)
    public CountedResult<EmailFromDto> findKnownEmailsFrom(String query, String emailFrom, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        List foundEmailsFrom = this.emailFromDao.findKnownEmailsFrom(query, emailFrom, start, limit, sortBy, sortDirection).stream().map(EmailFromDto::new).collect(Collectors.toList());
        long count = this.emailFromDao.getKnownEmailsCount(query, emailFrom);
        return new CountedResult(count, foundEmailsFrom);
    }

    @Transactional(readOnly=true)
    public List<Template> findByEmails(String emailFrom, String emailTo, boolean domainMatch) {
        return this.templateDao.findByEmails(emailFrom, emailTo, domainMatch);
    }

    @Transactional(readOnly=true)
    public boolean isSupplierSupported(String emailFrom, String emailTo) {
        return this.templateDao.exists(emailFrom, emailTo);
    }

    private static TemplateDto toTemplateDto(Template template) {
        return TemplateDto.builder().id(template.getId()).emailsFrom(template.getEmailsFrom().stream().map(EmailFrom::getEmailFrom).collect(Collectors.toList())).emailTo(template.getEmailTo()).fileId(template.getTemplateDefinition().getFileId()).fileExists(TemplateService.getFileExists(template)).phrase(template.getTemplateDefinition().getPhrase()).phraseLocation(TemplateService.mapPhraseLocation(template.getTemplateDefinition().getPhraseLocation())).priority(template.getTemplateDefinition().getPriority()).build();
    }

    private static boolean getFileExists(Template template) {
        DocumentClass templateDocumentClass = TemplateService.getTemplateDocumentClass();
        if (templateDocumentClass == null) {
            return false;
        }
        return TemplateService.getFileExists(template.getTemplateDefinition().getFileId(), templateDocumentClass);
    }

    private static boolean getFileExists(long fileId, DocumentClass templateDocumentClass) {
        DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
        WfDocument wfDocument = documentFinder.findByFileId(Long.valueOf(fileId), templateDocumentClass.getId());
        return Objects.nonNull(wfDocument);
    }

    private static String mapPhraseLocation(TemplatePhraseLocation phraseLocation) {
        return phraseLocation != null ? phraseLocation.getName() : "";
    }

    @Transactional(readOnly=true)
    public List<Template> getAll() {
        return this.templateDao.getAll(new String[0]);
    }

    @Transactional(readOnly=true)
    public Optional<Template> findByEmailsWithoutFile(String emailFrom, String emailTo) {
        return this.templateDao.findByEmailsWithoutFile(emailFrom, emailTo);
    }

    @Transactional(readOnly=true)
    public Template getById(long id) {
        return (Template)this.templateDao.get(Long.valueOf(id));
    }

    @Transactional
    public void delete(long id) {
        Template template = this.getById(id);
        if (template == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.delete-template.template-does-not-exist"));
        }
        long fileId = template.getTemplateDefinition().getFileId();
        this.templateDao.delete(template);
        DocumentClass templateDocumentClass = TemplateService.getTemplateDocumentClass();
        if (templateDocumentClass == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.application.add-email.status.doc-class-does-not-exist"));
        }
        if (TemplateService.getFileExists(fileId, templateDocumentClass)) {
            this.removeRelatedFiles(id, fileId, templateDocumentClass);
        }
    }

    @Transactional
    public void detach(long id) {
        Template template = this.getById(id);
        if (template == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.validator.delete-template.template-does-not-exist"));
        }
        DocumentClass templateDocumentClass = TemplateService.getTemplateDocumentClass();
        if (templateDocumentClass == null) {
            throw new IllegalArgumentException(this.translatorService.translateMessage("efaktura.application.add-email.status.doc-class-does-not-exist"));
        }
        long fileId = template.getTemplateDefinition().getFileId();
        template.getTemplateDefinition().setFileId(-1L);
        this.edit(template);
        this.removeRelatedFiles(id, fileId, templateDocumentClass);
    }

    private void removeRelatedFiles(long templateId, long fileId, DocumentClass templateDocumentClass) {
        FileService fileService = (FileService)SpringContext.getBean(FileService.class);
        long templateIdIndexId = this.getTemplateIdIndexId(templateDocumentClass);
        if (templateIdIndexId != -1L) {
            HashMap<Long, Long> indexes = new HashMap<Long, Long>();
            indexes.put(templateIdIndexId, templateId);
            FileFinder fileFinder = FinderFactory.getFileFinder();
            List docsToRemove = fileFinder.findByIndexes(indexes, templateDocumentClass.getId());
            if (CollectionUtils.isNotEmpty((Collection)docsToRemove)) {
                for (WfFile docToRemove : docsToRemove) {
                    fileService.deleteFile(Long.valueOf(docToRemove.getId()));
                }
            }
        } else {
            fileService.deleteFile(Long.valueOf(fileId));
        }
    }

    private static DocumentClass getTemplateDocumentClass() {
        String processTypeName = "pefaktur";
        String taskTypeName = "templatesadministration";
        String processFieldName = "templatesdocclass";
        ProcessDataService processDataService = (ProcessDataService)SpringContext.getBean(ProcessDataService.class);
        String documentClassName = processDataService.getProcessData(processTypeName, taskTypeName, processFieldName);
        if (StringUtils.isBlank((CharSequence)documentClassName)) {
            documentClassName = DEFAULT_TEMPLATE_DOCUMENT_CLASS_NAME;
        }
        DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
        return documentClassService.getDocumentClass(documentClassName, new String[]{"indexes"});
    }

    private long getTemplateIdIndexId(DocumentClass documentClass) {
        for (DocumentClassIndex index : documentClass.getIndexes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)index.getName(), (CharSequence)TEMPLATE_ID_INDEX_NAME)) continue;
            return index.getId();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateDownloadDto download(long fileId) throws IOException {
        TemplateDownloadDto templateDownloadDto;
        FileService fileService = (FileService)SpringContext.getBean(FileService.class);
        WfFile document = fileService.getFile(Long.valueOf(fileId), new String[0]);
        File file = new File(document.getFullPath());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            TemplateDownloadDto dto = new TemplateDownloadDto();
            dto.setBytes(IOUtils.toByteArray((InputStream)inputStream));
            dto.setFileName(document.getFileName());
            templateDownloadDto = dto;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return templateDownloadDto;
    }

    public List<PhraseLocationDto> getPhraseLocations() {
        return Arrays.stream(TemplatePhraseLocation.values()).map(phraseLocation -> {
            if (phraseLocation == TemplatePhraseLocation.UNKNOWN) {
                return new PhraseLocationDto(TemplatePhraseLocation.UNKNOWN.getName(), "");
            }
            String translatedName = this.translatorService.translateMessage("efaktura.phrase-location." + phraseLocation.getName().toLowerCase());
            return new PhraseLocationDto(phraseLocation.getName(), translatedName);
        }).collect(Collectors.toList());
    }
}

