/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.seenmail;

import com.suncode.plugin.efaktura.dao.seenmail.SeenMailDao;
import com.suncode.plugin.efaktura.model.seenmail.SeenMail;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeenMailService {
    @Autowired
    private SeenMailDao seenMailDao;

    @Transactional
    public void add(SeenMail seenMail) {
        this.seenMailDao.save(seenMail);
    }

    @Transactional
    public void remove(SeenMail seenMail) {
        this.seenMailDao.delete(seenMail);
    }

    @Transactional(readOnly=true)
    public boolean wasSeen(String email, String messageUid) {
        Optional<SeenMail> seenMail = this.seenMailDao.findByEmailAndMessageUid(email, messageUid);
        return seenMail.isPresent();
    }

    @Transactional
    public void deleteAllByEmail(String email) {
        this.seenMailDao.deleteAllByEmail(email);
    }

    @Transactional
    public void deleteByEmailAndMessageUid(String email, String messageUid) {
        Optional<SeenMail> seenMail = this.seenMailDao.findByEmailAndMessageUid(email, messageUid);
        seenMail.ifPresent(sm -> this.seenMailDao.delete(sm));
    }

    @Transactional(readOnly=true)
    public Set<SeenMail> getSeenMails(String email, List<String> messageUids) {
        return new LinkedHashSet<SeenMail>(this.seenMailDao.findAllByEmailAndMessageUids(email, messageUids));
    }
}

