/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.mailtodelete;

import com.suncode.plugin.efaktura.dao.mailtodelete.MailToDeleteDao;
import com.suncode.plugin.efaktura.model.mailtodelete.MailToDelete;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailToDeleteService {
    @Autowired
    private MailToDeleteDao mailToDeleteDao;

    @Transactional
    public long add(MailToDelete mailToDelete) {
        return (Long)this.mailToDeleteDao.save(mailToDelete);
    }

    @Transactional
    public void remove(String email, String messageUid) {
        MailToDelete mailToDelete = this.mailToDeleteDao.findByEmailAndMessageUid(email, messageUid);
        if (mailToDelete != null) {
            this.mailToDeleteDao.delete(mailToDelete);
        }
    }

    @Transactional(readOnly=true)
    public List<String> getMessageUids(String email) {
        return this.mailToDeleteDao.findAllByEmail(email).stream().map(MailToDelete::getMessageUid).collect(Collectors.toList());
    }
}

