/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.license;

import com.suncode.plugin.efaktura.dao.license.LicenseDao;
import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.service.xml.XmlAnalyzerService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.LicenseException;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import de.idyl.winzipaes.AesZipFileDecrypter;
import de.idyl.winzipaes.AesZipFileEncrypter;
import de.idyl.winzipaes.impl.AESDecrypter;
import de.idyl.winzipaes.impl.AESDecrypterBC;
import de.idyl.winzipaes.impl.AESEncrypter;
import de.idyl.winzipaes.impl.AESEncrypterBC;
import de.idyl.winzipaes.impl.ExtZipEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class LicenseService {
    private static final String LICENSE_PASSWORD = "lxia=QZ56c4X-gh.987l#q";
    private static final String LICENSE_CODE = "zhfqwWE871nx6FvkD660Yzf";
    public static Logger log = Logger.getLogger(LicenseService.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private LicenseDao licenseDao;
    @Autowired
    private XmlAnalyzerService xmlAnalyzerService;

    @Transactional
    public void add(License license) {
        this.licenseDao.save(license);
    }

    @Transactional
    public void edit(License license) {
        this.licenseDao.update(license);
    }

    @Transactional
    public void remove(License license) {
        this.licenseDao.delete(license);
    }

    @Transactional(readOnly=true)
    public Optional<License> get() {
        return this.licenseDao.getAll(new String[0]).stream().findFirst();
    }

    public void validateWhenAdding(String licenseFilePath) throws LicenseException {
        log.trace((Object)"********** validateWhenAdding( licenseFilePath ) **********");
        boolean correct = false;
        try {
            Element startDateElem;
            NodeList startDateValue;
            String value;
            SimpleDateFormat sdf;
            Date date;
            Element invoicesElem;
            NodeList invoicesValue;
            String value2;
            int inv;
            Element limitElem;
            NodeList limitValue;
            String value3;
            int limit;
            Element controlElem;
            NodeList controlValue;
            String value4;
            log.info((Object)"Weryfikacja poprawnosci pliku licencyjnego modulu Plus E-faktura");
            int lastDotPos = licenseFilePath.lastIndexOf(".");
            String ext = licenseFilePath.substring(lastDotPos + 1, licenseFilePath.length());
            if (ext == null || !ext.equalsIgnoreCase("xml")) {
                throw new LicenseException("Plik licencyjny modulu Plus E-faktura nie jest plikiem o wymaganym rozszerzeniu .xml");
            }
            String xmlContent = this.xmlAnalyzerService.convertXMLFileToStringFromFilePath(licenseFilePath);
            Document license = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            license.getDocumentElement().normalize();
            String rootElement = license.getDocumentElement().getNodeName();
            if (!rootElement.equals("PlusEFakturaLicense")) {
                throw new LicenseException("Licencja nie jest licencja modulu Plus E-faktura. Niepoprawna nazwa elementu nadrzednego");
            }
            NodeList controlList = license.getElementsByTagName("ControlCode");
            Node oneControl = controlList.item(0);
            if (oneControl.getNodeType() == 1 && (value4 = (controlValue = (controlElem = (Element)oneControl).getChildNodes()).item(0).getNodeValue()).equals(LICENSE_CODE)) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole ControlCode) - nieautoryzowana licencja");
            }
            correct = false;
            NodeList limitList = license.getElementsByTagName("Limit");
            Node oneLimit = limitList.item(0);
            if (oneLimit.getNodeType() == 1 && (limit = Integer.parseInt(value3 = (limitValue = (limitElem = (Element)oneLimit).getChildNodes()).item(0).getNodeValue())) >= 0) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole Limit ma wartosc ujemna)");
            }
            correct = false;
            NodeList invoicesList = license.getElementsByTagName("NoOfInvoices");
            Node oneInvoices = invoicesList.item(0);
            if (oneInvoices.getNodeType() == 1 && (inv = Integer.parseInt(value2 = (invoicesValue = (invoicesElem = (Element)oneInvoices).getChildNodes()).item(0).getNodeValue())) == 0) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole NoOfInvoices ma wartosc rozna od 0)");
            }
            correct = false;
            NodeList startDateList = license.getElementsByTagName("StartDate");
            Node oneStartDate = startDateList.item(0);
            if (oneStartDate.getNodeType() == 1 && (date = (sdf = new SimpleDateFormat("yyyy-MM-dd")).parse(value = (startDateValue = (startDateElem = (Element)oneStartDate).getChildNodes()).item(0).getNodeValue())) != null) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole StartDate)");
            }
            log.info((Object)"Pozytywna weryfikacja pliku licencyjnego");
        }
        catch (NullPointerException e) {
            throw new LicenseException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura lub jego brak");
        }
        catch (NumberFormatException e) {
            throw new LicenseException("Wartosc w polu NoOfInvoices lub w polu Limit w pliku licencyjnym modulu Plus E-faktura nie jest liczba");
        }
        catch (ParseException e) {
            throw new LicenseException("Wartosc pola StartDate w pliku licencyjnym modulu Plus E-faktura nie ma poprawnego formatu daty");
        }
        catch (DOMException e) {
            throw new LicenseException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
        }
    }

    public void validateWhenUsing(String licenseFilePath) throws LicenseException {
        log.trace((Object)"********** validateWhenUsing( licenseFilePath ) **********");
        boolean correct = false;
        byte[] buf = null;
        try {
            Element startDateElem;
            NodeList startDateValue;
            String value;
            SimpleDateFormat sdf;
            Date date;
            Element invoicesElem;
            NodeList invoicesValue;
            String value2;
            int inv;
            Element limitElem;
            NodeList limitValue;
            String value3;
            int limit;
            Element controlElem;
            NodeList controlValue;
            String value4;
            log.info((Object)"Weryfikacja poprawnosci pliku licencyjnego modulu Plus E-faktura");
            int lastDotPos = licenseFilePath.lastIndexOf(".");
            String ext = licenseFilePath.substring(lastDotPos + 1, licenseFilePath.length());
            if (ext == null || !ext.equalsIgnoreCase("zip")) {
                throw new LicenseException("Plik licencyjny modulu Plus E-faktura nie znajduje sie w wymaganym archiwum .zip");
            }
            buf = this.unzip(licenseFilePath);
            if (buf == null || buf.length == 0) {
                throw new LicenseException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
            }
            String xmlContent = new String(buf);
            Document license = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            license.getDocumentElement().normalize();
            String rootElement = license.getDocumentElement().getNodeName();
            if (!rootElement.equals("PlusEFakturaLicense")) {
                throw new LicenseException("Licencja nie jest licencja modulu Plus E-faktura. Niepoprawna nazwa elementu nadrzednego");
            }
            NodeList controlList = license.getElementsByTagName("ControlCode");
            Node oneControl = controlList.item(0);
            if (oneControl.getNodeType() == 1 && (value4 = (controlValue = (controlElem = (Element)oneControl).getChildNodes()).item(0).getNodeValue()).equals(LICENSE_CODE)) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole ControlCode) - nieautoryzowana licencja");
            }
            correct = false;
            NodeList limitList = license.getElementsByTagName("Limit");
            Node oneLimit = limitList.item(0);
            if (oneLimit.getNodeType() == 1 && (limit = Integer.parseInt(value3 = (limitValue = (limitElem = (Element)oneLimit).getChildNodes()).item(0).getNodeValue())) >= 0) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole Limit ma wartosc ujemna)");
            }
            correct = false;
            NodeList invoicesList = license.getElementsByTagName("NoOfInvoices");
            Node oneInvoices = invoicesList.item(0);
            if (oneInvoices.getNodeType() == 1 && (inv = Integer.parseInt(value2 = (invoicesValue = (invoicesElem = (Element)oneInvoices).getChildNodes()).item(0).getNodeValue())) >= 0) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole NoOfInvoices ma wartosc ujemna)");
            }
            correct = false;
            NodeList startDateList = license.getElementsByTagName("StartDate");
            Node oneStartDate = startDateList.item(0);
            if (oneStartDate.getNodeType() == 1 && (date = (sdf = new SimpleDateFormat("yyyy-MM-dd")).parse(value = (startDateValue = (startDateElem = (Element)oneStartDate).getChildNodes()).item(0).getNodeValue())) != null) {
                correct = true;
            }
            if (!correct) {
                throw new LicenseException("Niepoprawny format pliku licencyjnego (pole StartDate)");
            }
            log.info((Object)"Pozytywna weryfikacja pliku licencyjnego");
        }
        catch (NullPointerException e) {
            throw new LicenseException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura lub jego brak");
        }
        catch (NumberFormatException e) {
            throw new LicenseException("Wartosc w polu NoOfInvoices lub w polu Limit w pliku licencyjnym modulu Plus E-faktura nie jest liczba");
        }
        catch (ParseException e) {
            throw new LicenseException("Wartosc pola StartDate w pliku licencyjnym modulu Plus E-faktura nie ma poprawnego formatu daty");
        }
        catch (DOMException e) {
            throw new LicenseException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
        }
    }

    public synchronized void zip(File inFile, File outFile) throws IOException {
        log.trace((Object)"********** zipLicense( inFile, outFile ) **********");
        AESEncrypterBC aesEncrypterBC = new AESEncrypterBC();
        AesZipFileEncrypter.zipAndEncrypt((File)inFile, (File)outFile, (String)LICENSE_PASSWORD, (AESEncrypter)aesEncrypterBC);
    }

    public synchronized byte[] unzip(String licensePath) throws LicenseException {
        byte[] buf = null;
        AesZipFileDecrypter decrypt = null;
        AESDecrypterBC aesDecrypterBC = new AESDecrypterBC();
        File zipFile = null;
        ExtZipEntry zipEntry = null;
        try {
            zipFile = new File(licensePath);
            if (zipFile == null || !zipFile.exists()) {
                throw new PlusEFakturaException("Plik licencyjny modulu Plus E-faktura nie istnieje w podanej lokalizacji " + licensePath);
            }
            decrypt = new AesZipFileDecrypter(zipFile, (AESDecrypter)aesDecrypterBC);
            List entries = decrypt.getEntryList();
            if (entries == null || entries.size() == 0) {
                throw new PlusEFakturaException("Brak pliku licencyjnego modulu Plus E-faktura w archiwum ZIP");
            }
            zipEntry = (ExtZipEntry)entries.get(0);
            if (zipEntry == null) {
                throw new PlusEFakturaException("Brak pliku licencyjnego modulu Plus E-faktura");
            }
            buf = decrypt.extractEntry(zipEntry, LICENSE_PASSWORD);
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        finally {
            try {
                if (decrypt != null) {
                    decrypt.close();
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public License renew() throws Exception {
        log.trace((Object)"********** renew() **********");
        License license = null;
        String licensePath = "";
        String sStartDate = "";
        String currentChecksum = "";
        String lastChecksum = "";
        Calendar currentDate = Calendar.getInstance();
        Calendar licenseExpirationDate = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dStartDate = null;
        Document xmlFile = null;
        File zipFile = null;
        File tempFile = null;
        byte[] buf = null;
        InputStream is = null;
        OutputStream out = null;
        int read = 0;
        byte[] bytes = new byte[1024];
        Object pathForTempFile = "";
        try {
            log.info((Object)"Sprawdzanie daty aktywnosci licencji");
            clientLog.info((Object)"Sprawdzanie daty aktywnosci licencji");
            Optional<License> licenseOpt = this.get();
            if (!licenseOpt.isPresent()) {
                throw new LicenseException("Brak wgranej licencji dla modulu Plus E-faktura");
            }
            license = licenseOpt.get();
            licensePath = license.getPath();
            if (StringUtils.isBlank((CharSequence)licensePath)) {
                throw new LicenseException("Licencja modulu Plus E-faktura nie okresla lokalizacji pliku licencyjnego");
            }
            zipFile = new File(licensePath);
            if (zipFile == null || !zipFile.exists()) {
                throw new LicenseException("Archiwum zip z plikiem licencyjnym modulu Plus E-faktura nie istnieje w lokalizacji " + licensePath + ". Proces odnawiania licencji wstrzymany");
            }
            lastChecksum = license.getChecksum();
            currentChecksum = PlusEFakturaTools.getSHA1Checksum(licensePath);
            if (!currentChecksum.equals(lastChecksum)) {
                throw new LicenseException("Niezgodnosc sumy kontrolnej archiwum zip z plikiem licencyjnym modulu Plus E-faktura. Licencja zostala podnieniona!!!");
            }
            this.validateWhenUsing(licensePath);
            currentDate.setTimeInMillis(new Date().getTime());
            sStartDate = this.getStartDate(licensePath);
            dStartDate = sdf.parse(sStartDate);
            licenseExpirationDate.setTime(dStartDate);
            licenseExpirationDate.add(5, 30);
            if (licenseExpirationDate.before(currentDate)) {
                log.info((Object)"Licencja wymaga odnowienia");
                clientLog.info((Object)"Licencja wymaga odnowienia");
                buf = this.unzip(licensePath);
                if (buf == null || buf.length == 0) {
                    throw new PlusEFakturaException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
                }
                String xmlContent = new String(buf);
                if (StringUtils.isBlank((CharSequence)xmlContent)) {
                    throw new PlusEFakturaException("Brak zawartosci pliku licencyjnego modulu Plus E-faktura");
                }
                xmlFile = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
                if (xmlFile == null) {
                    throw new PlusEFakturaException("Blad podczas konwersji zawartosci pliku licencyjnego do formy dokumentu");
                }
                xmlFile.getDocumentElement().normalize();
                NodeList invoicesList = xmlFile.getElementsByTagName("NoOfInvoices");
                Node oneInvoices = invoicesList.item(0);
                if (oneInvoices.getNodeType() != 1) {
                    throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
                }
                Element invoicesElem = (Element)oneInvoices;
                NodeList invoicesValue = invoicesElem.getChildNodes();
                invoicesValue.item(0).setNodeValue("0");
                NodeList startDateList = xmlFile.getElementsByTagName("StartDate");
                Node oneStartDate = startDateList.item(0);
                if (oneStartDate.getNodeType() != 1) {
                    throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
                }
                Element startDateElem = (Element)oneStartDate;
                NodeList startDateValue = startDateElem.getChildNodes();
                startDateValue.item(0).setNodeValue(sdf.format(currentDate.getTime()));
                is = this.xmlAnalyzerService.getInputStreamForDocumentObject(xmlFile);
                licensePath = PlusEFakturaTools.convertBackslashesToSlashes(licensePath);
                int lastSlashPos = licensePath.lastIndexOf("/");
                Object object = pathForTempFile = lastSlashPos != -1 ? licensePath.substring(0, lastSlashPos) : licensePath;
                if (!((String)pathForTempFile).endsWith("/")) {
                    pathForTempFile = (String)pathForTempFile + "/";
                }
                pathForTempFile = (String)pathForTempFile + "plusefaktura_license.xml";
                tempFile = new File((String)pathForTempFile);
                out = new FileOutputStream(tempFile);
                while ((read = is.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
                this.zip(tempFile, zipFile);
                this.updateChecksumForLicense(license);
                log.info((Object)"Licencja odnowiona na okres 30 dni");
                clientLog.info((Object)"Licencja odnowiona na okres 30 dni");
                log.info((Object)"Odblokowanie wysylania powiadomienia o wygascieniu licencji");
                license.setNotificationLimit(false);
                this.edit(license);
            } else {
                log.info((Object)"Licencja nie wymaga odnowienia");
                log.info((Object)("Najblizszy termin odnowienia licencji to " + sdf.format(licenseExpirationDate.getTime())));
                clientLog.info((Object)"Licencja nie wymaga odnowienia");
                clientLog.info((Object)("Najblizszy termin odnowienia licencji to " + sdf.format(licenseExpirationDate.getTime())));
            }
            License license2 = license;
            return license2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.close();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private String getStartDate(String licensePath) throws LicenseException {
        log.trace((Object)"********** getStartDate( licensePath ) **********");
        String sStartDate = "";
        Document xmlFile = null;
        byte[] buf = null;
        try {
            String value;
            buf = this.unzip(licensePath);
            if (buf == null || buf.length == 0) {
                throw new PlusEFakturaException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
            }
            String xmlContent = new String(buf);
            if (StringUtils.isBlank((CharSequence)xmlContent)) {
                throw new PlusEFakturaException("Brak zawartosci pliku licencyjnego modulu Plus E-faktura");
            }
            xmlFile = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            if (xmlFile == null) {
                throw new PlusEFakturaException("Blad podczas konwersji zawartosci pliku licencyjnego do formy dokumentu");
            }
            xmlFile.getDocumentElement().normalize();
            NodeList startDateList = xmlFile.getElementsByTagName("StartDate");
            Node oneStartDate = startDateList.item(0);
            if (oneStartDate.getNodeType() != 1) {
                throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
            }
            Element startDateElem = (Element)oneStartDate;
            NodeList startDateValue = startDateElem.getChildNodes();
            sStartDate = value = startDateValue.item(0).getNodeValue();
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        return sStartDate;
    }

    @Transactional
    public void updateChecksumForLicense(License license) {
        String sLicensePath = "";
        String sChecksum = "";
        try {
            sLicensePath = license.getPath();
            sChecksum = PlusEFakturaTools.getSHA1Checksum(sLicensePath);
            license.setChecksum(sChecksum);
            this.edit(license);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Transactional
    public void delete() {
        log.trace((Object)"********** delete() **********");
        License license = null;
        String licensePath = "";
        File licenseFile = null;
        try {
            Optional<License> licenseOpt = this.get();
            if (!licenseOpt.isPresent()) {
                throw new LicenseException("Modul Plus E-faktura nie posiada wgranej licencji. Usuwanie wstrzymane");
            }
            license = licenseOpt.get();
            licensePath = license.getPath();
            if (StringUtils.isBlank((CharSequence)licensePath)) {
                try {
                    this.remove(license);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new LicenseException("Nie uzyskano sciezki do archiwum zip z plikiem licencyjnym. Nie udalo sie usunac licencji z bazy danych");
                }
                throw new LicenseException("Usunieto licencje z bazy danych, lecz nie uzyskano sciezki do archiwum zip z plikiem licencyjnym");
            }
            licenseFile = new File(licensePath);
            if (licenseFile != null && licenseFile.exists()) {
                boolean deleted = licenseFile.delete();
                if (deleted) {
                    log.info((Object)("Usunieto archiwum zip z plikiem licencyjnym z lokalizacji " + licensePath));
                } else {
                    log.warn((Object)("Nie udalo sie usunac archiwum zip z plikiem licencyjnym z lokalizacji " + licensePath + ". Usun plik recznie"));
                }
            } else {
                log.warn((Object)("W zdefiniowanej lokalizacji " + licensePath + " nie istnieje archiwum zip z plikiem licencyjnym"));
            }
            try {
                this.remove(license);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                throw new LicenseException("Nie udalo sie usunac licencji z bazy danych");
            }
            log.info((Object)"Usunieto licencje z bazy danych");
        }
        catch (LicenseException exception) {
            log.warn((Object)exception.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public int getLimit(String licensePath) throws LicenseException {
        log.trace((Object)"********** getLimit( licensePath ) **********");
        int limit = -1;
        Document xmlFile = null;
        byte[] buf = null;
        try {
            buf = this.unzip(licensePath);
            if (buf == null || buf.length == 0) {
                throw new PlusEFakturaException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
            }
            String xmlContent = new String(buf);
            if (StringUtils.isBlank((CharSequence)xmlContent)) {
                throw new PlusEFakturaException("Brak zawartosci pliku licencyjnego modulu Plus E-faktura");
            }
            xmlFile = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            if (xmlFile == null) {
                throw new PlusEFakturaException("Blad podczas konwersji zawartosci pliku licencyjnego do formy dokumentu");
            }
            xmlFile.getDocumentElement().normalize();
            NodeList limitList = xmlFile.getElementsByTagName("Limit");
            Node oneLimit = limitList.item(0);
            if (oneLimit.getNodeType() != 1) {
                throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
            }
            Element limitElem = (Element)oneLimit;
            NodeList limitValue = limitElem.getChildNodes();
            String value = limitValue.item(0).getNodeValue();
            limit = Integer.parseInt(value);
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        return limit;
    }

    public int getNoOfInvoices(String licensePath) throws LicenseException {
        log.trace((Object)"********** getNoOfInvoices( licensePath ) **********");
        int noOfInvoices = -1;
        Document xmlFile = null;
        byte[] buf = null;
        try {
            buf = this.unzip(licensePath);
            if (buf == null || buf.length == 0) {
                throw new PlusEFakturaException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
            }
            String xmlContent = new String(buf);
            if (StringUtils.isBlank((CharSequence)xmlContent)) {
                throw new PlusEFakturaException("Brak zawartosci pliku licencyjnego modulu Plus E-faktura");
            }
            xmlFile = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            if (xmlFile == null) {
                throw new PlusEFakturaException("Blad podczas konwersji zawartosci pliku licencyjnego do formy dokumentu");
            }
            xmlFile.getDocumentElement().normalize();
            NodeList invoicesList = xmlFile.getElementsByTagName("NoOfInvoices");
            Node oneInvoices = invoicesList.item(0);
            if (oneInvoices.getNodeType() != 1) {
                throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
            }
            Element invoicesElem = (Element)oneInvoices;
            NodeList invoicesValue = invoicesElem.getChildNodes();
            String value = invoicesValue.item(0).getNodeValue();
            noOfInvoices = Integer.parseInt(value);
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        return noOfInvoices;
    }

    public boolean shouldSendLimitExceedNotification(License license) {
        log.trace((Object)"********** shouldSendLimitExceedNotification( License ) **********");
        return license.getNotificationLimit() == null || license.getNotificationLimit() == false;
    }

    public void incrementNoOfInvoices(String licensePath) throws LicenseException {
        log.trace((Object)"********** incrementNoOfInvoices( licensePath ) **********");
        File zipFile = null;
        File tempFile = null;
        byte[] buf = null;
        InputStream is = null;
        OutputStream out = null;
        int read = 0;
        byte[] bytes = new byte[1024];
        Object pathForTempFile = "";
        Document xmlFile = null;
        try {
            buf = this.unzip(licensePath);
            if (buf == null || buf.length == 0) {
                throw new PlusEFakturaException("Nie udalo sie rozpakowac pliku licencynjego modulu Plus E-faktura");
            }
            zipFile = new File(licensePath);
            String xmlContent = new String(buf);
            if (StringUtils.isBlank((CharSequence)xmlContent)) {
                throw new PlusEFakturaException("Brak zawartosci pliku licencyjnego modulu Plus E-faktura");
            }
            xmlFile = this.xmlAnalyzerService.convertStringToXMLFile(xmlContent);
            if (xmlFile == null) {
                throw new PlusEFakturaException("Blad podczas konwersji zawartosci pliku licencyjnego do formy dokumentu");
            }
            xmlFile.getDocumentElement().normalize();
            NodeList invoicesList = xmlFile.getElementsByTagName("NoOfInvoices");
            Node oneInvoices = invoicesList.item(0);
            if (oneInvoices.getNodeType() != 1) {
                throw new PlusEFakturaException("Niepoprawny format pliku licencyjnego modulu Plus E-faktura");
            }
            Element invoicesElem = (Element)oneInvoices;
            NodeList invoicesValue = invoicesElem.getChildNodes();
            String value = invoicesValue.item(0).getNodeValue();
            int noOfInvoices = Integer.parseInt(value);
            value = String.valueOf(++noOfInvoices);
            invoicesValue.item(0).setNodeValue(value);
            is = this.xmlAnalyzerService.getInputStreamForDocumentObject(xmlFile);
            licensePath = PlusEFakturaTools.convertBackslashesToSlashes(licensePath);
            int lastSlashPos = licensePath.lastIndexOf("/");
            pathForTempFile = licensePath.substring(0, lastSlashPos);
            if (!((String)pathForTempFile).endsWith("/")) {
                pathForTempFile = (String)pathForTempFile + "/";
            }
            pathForTempFile = (String)pathForTempFile + "plusefaktura_license.xml";
            tempFile = new File((String)pathForTempFile);
            out = new FileOutputStream(tempFile);
            while ((read = is.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.flush();
            this.zip(tempFile, zipFile);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (PlusEFakturaException e) {
            log.warn((Object)e.getMessage());
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new LicenseException("Blad w obsludze pliku licencyjnego modulu Plus E-faktura");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.close();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

