/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.model.seenmail;

import com.suncode.plugin.efaktura.model.seenmail.OldSeenMail;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="pm_efaktura_seen_mail", uniqueConstraints={@UniqueConstraint(columnNames={"email", "message_uid"})})
@SequenceGenerator(name="efaktura_seen_mail", sequenceName="pm_efaktura_seen_mail_id")
public class SeenMail
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="efaktura_seen_mail")
    private Long id;
    @Column
    private String email;
    @Column(name="message_uid")
    private String messageUid;
    @Column(name="date_of_read")
    private Date dateOfRead;
    @Column(name="attachment_message_id")
    private String attachmentMessageId;
    @Column(name="local_save_failed")
    private Boolean localSaveFailed = false;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMessageUid() {
        return this.messageUid;
    }

    public void setMessageUid(String messageUid) {
        this.messageUid = messageUid;
    }

    public Date getDateOfRead() {
        return this.dateOfRead;
    }

    public void setDateOfRead(Date dateOfRead) {
        this.dateOfRead = dateOfRead;
    }

    public String getAttachmentMessageId() {
        return this.attachmentMessageId;
    }

    public void setAttachmentMessageId(String attachmentMessageId) {
        this.attachmentMessageId = attachmentMessageId;
    }

    public Boolean getLocalSaveFailed() {
        return this.localSaveFailed;
    }

    public void setLocalSaveFailed(Boolean localSaveFailed) {
        this.localSaveFailed = localSaveFailed;
    }

    public static SeenMail fromOldSeenMail(OldSeenMail oldSeenMail) {
        SeenMail seenMail = new SeenMail();
        seenMail.setEmail(oldSeenMail.getEmail());
        seenMail.setMessageUid(oldSeenMail.getMessageUid());
        seenMail.setDateOfRead(oldSeenMail.getDateOfRead());
        seenMail.setAttachmentMessageId(oldSeenMail.getAttachmentMessageId());
        seenMail.setLocalSaveFailed(false);
        return seenMail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeenMail)) {
            return false;
        }
        SeenMail other = (SeenMail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$messageUid = this.getMessageUid();
        String other$messageUid = other.getMessageUid();
        return !(this$messageUid == null ? other$messageUid != null : !this$messageUid.equals(other$messageUid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeenMail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $messageUid = this.getMessageUid();
        result = result * 59 + ($messageUid == null ? 43 : $messageUid.hashCode());
        return result;
    }
}

