/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.EdiCoordinates;
import com.suncode.plugin.efaktura.editopdf.Record;
import com.suncode.plugin.efaktura.editopdf.Records;
import com.suncode.plugin.efaktura.editopdf.ValueFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Section
extends HashMap<String, Records> {
    private static final long serialVersionUID = 1L;

    public void addRecord(String label, Record record) {
        if (this.containsKey(label)) {
            Records records = (Records)this.get(label);
            this.addRecord(records, label, record);
        } else {
            Records records = new Records();
            this.addRecord(records, label, record);
        }
    }

    private void addRecord(Records records, String label, Record record) {
        records.add(record);
        this.put(label, records);
    }

    public List<String> getValues(EdiCoordinates ediCoordinates) {
        String label = ediCoordinates.getLabel();
        if (this.containsKey(label)) {
            ArrayList<String> values = new ArrayList<String>();
            Records records = (Records)this.get(label);
            List<String> filters = ediCoordinates.getFilters();
            List<ValueFunction> valueFunctions = ediCoordinates.getValueFunctions();
            for (Record record : records) {
                if (!record.areFiltersFulfilled(filters)) continue;
                int index = ediCoordinates.getIndex();
                values.add(record.getValue(index, valueFunctions));
            }
            return values;
        }
        return new ArrayList<String>();
    }

    public String getValue(EdiCoordinates ediCoordinates) {
        List<String> values = this.getValues(ediCoordinates);
        int elementNo = ediCoordinates.getLine() - 1;
        if (elementNo < 0) {
            return StringUtils.join(values, (String)" ");
        }
        if (CollectionUtils.size(values) > elementNo) {
            return values.get(elementNo);
        }
        return "";
    }
}

