/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.EdiCoordinates;
import com.suncode.plugin.efaktura.editopdf.SectionName;
import com.suncode.plugin.efaktura.editopdf.ValueFunction;
import com.suncode.plugin.efaktura.editopdf.ValueFunctionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EdiCoordinatesBuilder {
    private static final String COORDINATES_SEPARATOR_ESCAPE = "\\:";
    private static final String COORDINATES_SEPARATOR_REPLACEMENT = "@COORDINATES_SEPARATOR_REPLACEMENT@";
    private static final String COORDINATES_SEPARATOR = ":";
    private static final int REQUIRED_SECTIONS = 4;
    private static final String FILTER_PREFIX = "(";
    private static final String FILTER_POSTFIX = ")";
    private static final Pattern FILTER_PATTERN = Pattern.compile("([(](\\w*|[*])[)])");
    @Autowired
    private ValueFunctionBuilder valueFunctionBuilder;

    public EdiCoordinates build(String coordinates) {
        coordinates = StringUtils.replace((String)coordinates, (String)COORDINATES_SEPARATOR_ESCAPE, (String)COORDINATES_SEPARATOR_REPLACEMENT);
        String[] splitted = StringUtils.split((String)coordinates, (String)COORDINATES_SEPARATOR);
        String sectionName = new String(splitted[1]);
        String label = this.buildLabel(splitted);
        List<String> filters = this.buildFilters(splitted);
        int index = Integer.valueOf(splitted[3]);
        ArrayList<ValueFunction> valueFunctions = new ArrayList<ValueFunction>();
        EdiCoordinates ediCoordinates = new EdiCoordinates();
        ediCoordinates.setSectionName(SectionName.getByName(sectionName));
        ediCoordinates.setLabel(label);
        ediCoordinates.setFilters(filters);
        ediCoordinates.setIndex(index);
        if (splitted.length > REQUIRED_SECTIONS) {
            int currentIndex = REQUIRED_SECTIONS;
            if (NumberUtils.isDigits((String)splitted[4])) {
                ediCoordinates.setLine(Integer.valueOf(splitted[4]));
                ++currentIndex;
            }
            for (int i = currentIndex; i < splitted.length; ++i) {
                String functionDefinition = StringUtils.replace((String)splitted[i], (String)COORDINATES_SEPARATOR_REPLACEMENT, (String)COORDINATES_SEPARATOR);
                valueFunctions.add(this.buildValueFunction(functionDefinition));
            }
        }
        ediCoordinates.setValueFunctions(valueFunctions);
        return ediCoordinates;
    }

    private String buildLabel(String[] splitted) {
        return StringUtils.substringBefore((String)splitted[2], (String)FILTER_PREFIX);
    }

    private List<String> buildFilters(String[] splitted) {
        ArrayList<String> filters = new ArrayList<String>();
        String value = new String(splitted[2]);
        Matcher matcher = FILTER_PATTERN.matcher(value);
        while (matcher.find()) {
            String filter = this.buildFilter(matcher);
            filters.add(filter);
        }
        return filters;
    }

    private String buildFilter(Matcher matcher) {
        String group = matcher.group();
        return StringUtils.substringBetween((String)group, (String)FILTER_PREFIX, (String)FILTER_POSTFIX);
    }

    private ValueFunction buildValueFunction(String functionDefinition) {
        return this.valueFunctionBuilder.build(functionDefinition);
    }
}

