/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.docxtopdf;

import com.suncode.plugin.efaktura.docxtopdf.Docx4jDocxToPdfConverterImpl;
import com.suncode.plugin.efaktura.docxtopdf.DocxToPdfConverter;
import com.suncode.plugin.efaktura.docxtopdf.VariablesPreparator;
import com.suncode.plugin.efaktura.util.DocxToPdfConverterType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DocxTemplateToPdfConverter {
    public static Logger log = Logger.getLogger(DocxTemplateToPdfConverter.class);
    @Autowired
    private VariablesPreparator variablesPreparator;
    @Autowired
    @Qualifier(value="docx4jDocxToPdfConverter")
    private DocxToPdfConverter docx4jDocxToPdfConverter;
    @Autowired
    @Qualifier(value="officeDocxToPdfConverter")
    private DocxToPdfConverter officeDocxToPdfConverter;

    public byte[] convert(WordprocessingMLPackage template, HashMap<String, String> mappings, String converterType) {
        try {
            this.fillTemplate(template, mappings);
            return this.convert(template, converterType);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void fillTemplate(WordprocessingMLPackage template, HashMap<String, String> mappings) throws Exception {
        MainDocumentPart documentPart = template.getMainDocumentPart();
        this.replaceVariables(mappings, (JaxbXmlPart)documentPart);
        List sectionWrappers = template.getDocumentModel().getSections();
        if (CollectionUtils.isNotEmpty((Collection)sectionWrappers)) {
            for (SectionWrapper sectionWrapper : sectionWrappers) {
                HeaderFooterPolicy headerFooterPolicy = sectionWrapper.getHeaderFooterPolicy();
                if (headerFooterPolicy == null) continue;
                HeaderPart defaultHeader = headerFooterPolicy.getDefaultHeader();
                FooterPart defaultFooter = headerFooterPolicy.getDefaultFooter();
                HeaderPart evenHeader = headerFooterPolicy.getEvenHeader();
                FooterPart evenFooter = headerFooterPolicy.getEvenFooter();
                HeaderPart firstHeader = headerFooterPolicy.getFirstHeader();
                FooterPart firstFooter = headerFooterPolicy.getFirstFooter();
                if (defaultHeader != null) {
                    this.prepareVariables((JaxbXmlPartXPathAware)defaultHeader);
                    this.replaceVariables(mappings, (JaxbXmlPart)defaultHeader);
                }
                if (defaultFooter != null) {
                    this.prepareVariables((JaxbXmlPartXPathAware)defaultFooter);
                    this.replaceVariables(mappings, (JaxbXmlPart)defaultFooter);
                }
                if (evenHeader != null) {
                    this.prepareVariables((JaxbXmlPartXPathAware)evenHeader);
                    this.replaceVariables(mappings, (JaxbXmlPart)evenHeader);
                }
                if (evenFooter != null) {
                    this.prepareVariables((JaxbXmlPartXPathAware)evenFooter);
                    this.replaceVariables(mappings, (JaxbXmlPart)evenFooter);
                }
                if (firstHeader != null) {
                    this.prepareVariables((JaxbXmlPartXPathAware)firstHeader);
                    this.replaceVariables(mappings, (JaxbXmlPart)firstHeader);
                }
                if (firstFooter == null) continue;
                this.prepareVariables((JaxbXmlPartXPathAware)firstFooter);
                this.replaceVariables(mappings, (JaxbXmlPart)firstFooter);
            }
        }
    }

    private <T> void replaceVariables(HashMap<String, String> mappings, JaxbXmlPart<T> part) throws JAXBException, Docx4JException {
        part.variableReplace(mappings);
    }

    private <T> void prepareVariables(JaxbXmlPartXPathAware<T> element) {
        this.variablesPreparator.prepare(element);
    }

    public byte[] convert(WordprocessingMLPackage template, String converterType) {
        try {
            DocxToPdfConverter docxToPdfConverter = this.getDocxToPdfConverter(converterType);
            return docxToPdfConverter.convert(template);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private DocxToPdfConverter getDocxToPdfConverter(String converterType) {
        switch (DocxToPdfConverterType.getByName(converterType)) {
            case DOCX4J: {
                return this.docx4jDocxToPdfConverter;
            }
            case OFFICE: {
                return this.officeDocxToPdfConverter;
            }
        }
        return this.getCustomDocxToPdfConverter(converterType);
    }

    private DocxToPdfConverter getCustomDocxToPdfConverter(String classpath) {
        try {
            return (DocxToPdfConverter)Class.forName(classpath).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return new Docx4jDocxToPdfConverterImpl();
        }
    }
}

