/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.component.validator;

import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.util.EfakturaComponentCategory;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
public class AddEmailValidator {
    @Autowired
    private TemplateService templateService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("efaktura-add-email-validator")).name("efaktura.validator.add-email.name")).description("efaktura.validator.add-email.description")).category(new Category[]{new EfakturaComponentCategory()})).parameter().id("emailsFrom").name("efaktura.validator.add-email.parameters.emails-from.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("emailTo").name("efaktura.validator.add-email.parameters.email-to.name").type((Type)Types.STRING).create();
    }

    public void validate(@Param String[] emailsFrom, @Param String emailTo, ValidationErrors errors, Translator translator) {
        if (!com.suncode.plugin.efaktura.util.Validator.hasEmails(emailsFrom)) {
            errors.add(translator.getMessage("efaktura.validator.add-email.error-message.no-supplier-email"));
            return;
        }
        List<String> emailsFromList = Arrays.asList(emailsFrom);
        if (!com.suncode.plugin.efaktura.util.Validator.hasNoDuplications(emailsFromList)) {
            errors.add(translator.getMessage("efaktura.validator.add-email.error-message.email-duplication"));
            return;
        }
        emailsFromList.forEach(e -> {
            if (!com.suncode.plugin.efaktura.util.Validator.isValidEmail(e)) {
                errors.add(translator.getMessage("efaktura.validator.add-email.error-message.wrong-email-format") + ": " + e);
                return;
            }
        });
        if (StringUtils.isNotBlank((CharSequence)emailTo) && !com.suncode.plugin.efaktura.util.Validator.isValidEmail(emailTo)) {
            errors.add(translator.getMessage("efaktura.validator.add-email.error-message.wrong-email-format") + ": " + emailTo);
            return;
        }
        emailsFromList.forEach(e -> {
            Optional<Template> templateOpt = this.templateService.findByEmailsWithoutFile((String)e, emailTo);
            if (templateOpt.isPresent()) {
                errors.add(translator.getMessage("efaktura.validator.add-email.error-message.email-address") + ": " + e + ". " + translator.getMessage("efaktura.validator.add-email.error-message.supplier-already-added"));
                return;
            }
        });
    }
}

