/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.service.seenmail.SeenMailService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class DeleteSeenMailScheduledTask {
    public static Logger log = Logger.getLogger(DeleteSeenMailScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private SeenMailService seenMailService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-delete-seen-mail-scheduled-task")).name("efaktura.scheduled-task.delete-seen-mail.name")).description("efaktura.scheduled-task.delete-seen-mail.description")).parameter().id("emailsFrom").name("efaktura.scheduled-task.delete-seen-mail.parameters.emails-from.name").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param String[] emailsFrom) {
        log.info((Object)("**************** deleteSeenMails(emailsFrom=" + String.valueOf(emailsFrom) + ") *****************"));
        clientLog.info((Object)("Usuwanie z bazy danych przeczytanych wiadomosci ze skrzynek: " + String.valueOf(emailsFrom)));
        long startTime = new Date().getTime();
        try {
            if (ArrayUtils.isEmpty((Object[])emailsFrom)) {
                throw new PlusEFakturaException("Brak adres\u00f3w e-mail nadawcy");
            }
            for (String emailFrom : emailsFrom) {
                this.seenMailService.deleteAllByEmail(emailFrom);
                log.info((Object)("Przeczytane wiadomosci dla skrzynki " + emailFrom + " usuniete z bazy danych z tabeli pm_efaktura_seen_mail"));
                clientLog.info((Object)("Przeczytane wiadomosci dla skrzynki " + emailFrom + " usuniete z bazy danych z tabeli pm_efaktura_seen_mail"));
            }
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
            clientLog.warn((Object)exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        long stopTime = new Date().getTime();
        String durationTime = PlusEFakturaTools.formatDuration(stopTime - startTime);
        log.info((Object)("Czas usuwania wiadomosci przeczytanych z tabeli pm_plusefaktura_seenmails: " + durationTime));
        clientLog.info((Object)("Czas usuwania wiadomosci przeczytanych z tabeli pm_plusefaktura_seenmails: " + durationTime));
        clientLog.info((Object)"Zakonczono proces usuwania wiadomosci przeczytanych");
    }
}

