/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.EdiUnit;
import com.suncode.plugin.efaktura.editopdf.ValueFunction;
import com.suncode.plugin.efaktura.editopdf.ValueFunctionType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ValueFunctionEvaluator {
    public static Logger log = Logger.getLogger(ValueFunctionEvaluator.class);

    public static String evaluate(String value, ValueFunction valueFunction) {
        try {
            ValueFunctionType type = ValueFunctionType.getByName(valueFunction.getName());
            List<String> parameters = valueFunction.getParameters();
            ValueFunctionEvaluator.validateParameters(type, parameters);
            switch (type) {
                case addPrefix: {
                    return ValueFunctionEvaluator.addPrefix(value, parameters);
                }
                case addPostfix: {
                    return ValueFunctionEvaluator.addPostfix(value, parameters);
                }
                case customFunction: {
                    return ValueFunctionEvaluator.customFunction(value, parameters);
                }
                case formatAmount: {
                    return ValueFunctionEvaluator.formatAmount(value, parameters);
                }
                case formatDateTime: {
                    return ValueFunctionEvaluator.formatDateTime(value, parameters);
                }
                case removeCharacters: {
                    return ValueFunctionEvaluator.removeCharacters(value, parameters);
                }
                case replaceCharacters: {
                    return ValueFunctionEvaluator.replaceCharacters(value, parameters);
                }
                case skipEmptyTableValue: {
                    return ValueFunctionEvaluator.skipEmptyTableValue(value);
                }
                case transformUnit: {
                    return ValueFunctionEvaluator.transformUnit(value);
                }
            }
            return value;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return value;
        }
    }

    private static void validateParameters(ValueFunctionType type, List<String> parameters) {
        if (ValueFunctionEvaluator.hasSpecifiedNoOfCharacters(type) && type.getNoOfParameters() != CollectionUtils.size(parameters)) {
            throw new IllegalArgumentException("Niezgodnosc liczby parametrow funkcji " + type.name());
        }
    }

    private static boolean hasSpecifiedNoOfCharacters(ValueFunctionType type) {
        return type.getNoOfParameters() != Integer.MAX_VALUE;
    }

    private static String addPrefix(String value, List<String> parameters) {
        String prefix = parameters.get(0);
        StringBuilder newValue = new StringBuilder();
        newValue.append(prefix);
        newValue.append(value);
        return newValue.toString();
    }

    private static String customFunction(String value, List<String> parameters) throws Exception {
        int minSize = 2;
        if (CollectionUtils.size(parameters) < minSize) {
            throw new IllegalArgumentException("Zbyt mala liczba parametrow funkcji customFunction");
        }
        String className = parameters.get(0);
        String methodName = parameters.get(1);
        Class<?> clazz = Class.forName(className);
        Method method = clazz.getMethod(methodName, String.class, List.class);
        int modifiers = method.getModifiers();
        Class<?> returnType = method.getReturnType();
        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && returnType != null && returnType.equals(String.class)) {
            List<String> subparameters = parameters.subList(minSize, CollectionUtils.size(parameters));
            return (String)method.invoke(null, value, subparameters);
        }
        return value;
    }

    private static String addPostfix(String value, List<String> parameters) {
        String postfix = parameters.get(0);
        StringBuilder newValue = new StringBuilder();
        newValue.append(value);
        newValue.append(postfix);
        return newValue.toString();
    }

    private static String formatAmount(String value, List<String> parameters) {
        BigDecimal decimal = new BigDecimal(value);
        String format = parameters.get(0);
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(decimal.doubleValue());
    }

    private static String formatDateTime(String value, List<String> parameters) throws ParseException {
        String fromPattern = parameters.get(0);
        String toPattern = parameters.get(1);
        SimpleDateFormat fromDateFormat = new SimpleDateFormat(fromPattern);
        Date date = fromDateFormat.parse(value);
        SimpleDateFormat toDateFormat = new SimpleDateFormat(toPattern);
        return toDateFormat.format(date);
    }

    private static String removeCharacters(String value, List<String> parameters) {
        if (CollectionUtils.isNotEmpty(parameters)) {
            for (String parameter : parameters) {
                value = StringUtils.remove((String)value, (String)parameter);
            }
        }
        return value;
    }

    private static String replaceCharacters(String value, List<String> parameters) {
        String search = parameters.get(0);
        String replacement = parameters.get(1);
        return StringUtils.replace((String)value, (String)search, (String)replacement);
    }

    private static String skipEmptyTableValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "@EDI_TO_PDF_TABLE_TEXT_TO_SKIP@";
        }
        return value;
    }

    private static String transformUnit(String value) {
        return EdiUnit.getNameByCode(value);
    }
}

