/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.editopdf;

import com.suncode.plugin.efaktura.editopdf.ValueFunction;
import com.suncode.plugin.efaktura.editopdf.ValueFunctionEvaluator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Record
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private static final String ALL_VALUES_FILTER = "*";

    public void addValue(String value) {
        this.add(value);
    }

    public boolean areFiltersFulfilled(List<String> filters) {
        if (CollectionUtils.isNotEmpty(filters)) {
            int counter = 0;
            for (String filter : filters) {
                if (!this.isFilterFulfilled(filter, counter)) {
                    return false;
                }
                ++counter;
            }
        }
        return true;
    }

    private boolean isFilterFulfilled(String filter, int counter) {
        return this.isAllValuesFilter(filter) || this.isCounterWithinSize(counter) && this.isValueEqualFilter(filter, counter);
    }

    private boolean isAllValuesFilter(String filter) {
        return StringUtils.equals((CharSequence)filter, (CharSequence)ALL_VALUES_FILTER);
    }

    private boolean isCounterWithinSize(int counter) {
        return this.size() > counter;
    }

    private boolean isValueEqualFilter(String filter, int counter) {
        String value = (String)this.get(counter);
        return StringUtils.equals((CharSequence)filter, (CharSequence)value);
    }

    public String getValue(int index, List<ValueFunction> valueFunctions) {
        String value = this.getValue(index);
        return this.applayValueFunctions(value, valueFunctions);
    }

    private String getValue(int index) {
        int elementNo = index - 1;
        if (this.size() > elementNo) {
            return (String)this.get(elementNo);
        }
        return "";
    }

    private String applayValueFunctions(String value, List<ValueFunction> valueFunctions) {
        if (CollectionUtils.isNotEmpty(valueFunctions)) {
            for (ValueFunction valueFunction : valueFunctions) {
                value = this.applyValuFunction(value, valueFunction);
            }
        }
        return value;
    }

    private String applyValuFunction(String value, ValueFunction valueFunction) {
        return ValueFunctionEvaluator.evaluate(value, valueFunction);
    }
}

