/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.license;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.license.LicenseDao;
import com.suncode.plugin.efaktura.model.license.License;
import com.suncode.plugin.efaktura.model.license.OldLicense;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class LicenseDaoImpl
extends EfakturaHibernateEditableDao<License, Long>
implements LicenseDao {
    private static final String OLD_LICENSE_TABLE_NAME = "pm_plusefaktura_license";
    private static final String FIND_ALL_OLD_LICENSES_QUERY = "select path, dateofaddition, checksum, limitnotification from pm_plusefaktura_license";

    @Override
    public List<OldLicense> findAllOldLicenses() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldLicense>>(){

                public List<OldLicense> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(LicenseDaoImpl.FIND_ALL_OLD_LICENSES_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldLicense> oldLicenses = new ArrayList<OldLicense>();
                    while (resultSet.next()) {
                        oldLicenses.add(LicenseDaoImpl.this.buildOldLicense(resultSet));
                    }
                    return oldLicenses;
                }
            });
        }
        return new ArrayList<OldLicense>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_LICENSE_TABLE_NAME);
    }

    private OldLicense buildOldLicense(ResultSet resultSet) throws SQLException {
        OldLicense oldLicense = new OldLicense();
        oldLicense.setPath(resultSet.getString(1));
        oldLicense.setDateOfAddition(resultSet.getDate(2));
        oldLicense.setChecksum(resultSet.getString(3));
        oldLicense.setLimitNotification(resultSet.getBoolean(4));
        return oldLicense;
    }
}

