/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.rest;

import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.util.TemplateFilter;
import com.suncode.plugin.efaktura.util.TemplatePhraseLocation;
import com.suncode.plugin.efaktura.web.support.dto.EmailFromDto;
import com.suncode.plugin.efaktura.web.support.dto.PhraseLocationDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDownloadDto;
import com.suncode.plugin.efaktura.web.support.dto.TemplateDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/template"})
public class TemplateController {
    private static final String XML_CONTENT_TYPE = "application/xml-dtd";
    private static final String USERNAME_ATTRIBUTE_NAME = "username";
    @Autowired
    private TemplateService templateService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<TemplateDto> findAll(@RequestParam(required=false) String emailsFrom, @RequestParam(required=false) String emailTo, @RequestParam(required=false) String phrase, @RequestParam(required=false) TemplatePhraseLocation phraseLocation, @RequestParam(required=false) Integer priority, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String sortBy, @RequestParam(required=false) SortDirection sortDirection) {
        return this.templateService.findAll(this.buildTemplateFilter(emailsFrom, emailTo, phrase, phraseLocation, priority, sortBy, sortDirection), start, limit);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Void> addTemplate(HttpServletRequest request, @RequestParam List<String> emailsFrom, @RequestParam String emailTo, @RequestParam String phrase, @RequestParam(required=false, defaultValue="UNKNOWN") TemplatePhraseLocation phraseLocation, @RequestParam(required=false) Integer priority, @RequestParam MultipartFile file) throws IOException {
        String userId = TemplateController.getUserIdFromSession(request);
        this.templateService.add(userId, emailsFrom, emailTo, phrase, phraseLocation, priority, file);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"simple"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Void> addTemplateWithoutFile(@RequestParam List<String> emailsFrom, @RequestParam String emailTo) {
        this.templateService.add(emailsFrom, emailTo);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Void> editTemplate(HttpServletRequest request, @PathVariable long id, @RequestParam List<String> emailsFrom, @RequestParam String emailTo, @RequestParam String phrase, @RequestParam(required=false, defaultValue="UNKNOWN") TemplatePhraseLocation phraseLocation, @RequestParam(required=false) Integer priority, @RequestParam(required=false) MultipartFile file) throws IOException {
        String userId = TemplateController.getUserIdFromSession(request);
        this.templateService.edit(id, userId, emailsFrom, emailTo, phrase, phraseLocation, priority, file);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"simple/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Void> editTemplateWithoutFile(@PathVariable long id, @RequestParam List<String> emailsFrom, @RequestParam String emailTo) throws IOException {
        this.templateService.editWithoutFile(id, emailsFrom, emailTo);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Void> deleteTemplate(@PathVariable Long id) {
        this.templateService.delete(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"phrase-locations"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<PhraseLocationDto> getPhraseLocations() {
        List<PhraseLocationDto> phraseLocations = this.templateService.getPhraseLocations();
        return new CountedResult((long)phraseLocations.size(), phraseLocations);
    }

    @RequestMapping(value={"known-emailsFrom"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<EmailFromDto> getKnownEmailsFrom(@RequestParam String query, @RequestParam String emailFrom, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam String sortBy, @RequestParam SortDirection sortDirection) {
        return this.templateService.findKnownEmailsFrom(query, emailFrom, start, limit, sortBy, sortDirection);
    }

    private TemplateFilter buildTemplateFilter(String emailsFrom, String emailTo, String phrase, TemplatePhraseLocation phraseLocation, Integer priority, String sortBy, SortDirection sortDirection) {
        return TemplateFilter.builder().emailsFrom(this.getEmailsList(emailsFrom)).emailTo(this.getFilterValue(emailTo)).phrase(this.getFilterValue(phrase)).phraseLocation(phraseLocation).priority(priority).sortBy(sortBy).sortDirection(sortDirection).build();
    }

    private List<String> getEmailsList(String emails) {
        if (StringUtils.isNotEmpty((CharSequence)emails)) {
            return Arrays.asList(StringUtils.split((String)emails, (String)","));
        }
        return Collections.emptyList();
    }

    private String getFilterValue(String parameter) {
        return StringUtils.isNotEmpty((CharSequence)parameter) ? parameter : null;
    }

    @RequestMapping(value={"download/{fileId}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> download(@PathVariable long fileId) throws IOException {
        TemplateDownloadDto dto = this.templateService.download(fileId);
        byte[] bytes = dto.getBytes();
        HttpHeaders responseHeaders = this.buildHeaders(bytes, XML_CONTENT_TYPE, dto.getFileName());
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(byte[] bytes, String contentType, String filename) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", filename);
        return responseHeaders;
    }

    public static String getUserIdFromSession(HttpServletRequest request) {
        return Optional.ofNullable(request.getSession(false)).map(session -> (String)session.getAttribute(USERNAME_ATTRIBUTE_NAME)).orElse("");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException exception) {
        return new ResponseEntity((Object)exception.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

