/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util.emailtopdf;

import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.emailtopdf.Email;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailAttachment;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailAttachmentBuilderImpl;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailBuilder;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPart;
import com.suncode.plugin.efaktura.util.emailtopdf.EmailPartBuilderImpl;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EmailBuilderImpl
implements EmailBuilder {
    public static Logger log = Logger.getLogger(EmailBuilderImpl.class);
    private static final String JOINER = "; ";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    public Email build(Message message) throws MessagingException, IOException {
        List<Part> parts = PlusEFakturaTools.decomposePart((Part)message);
        Email email = new Email();
        email.setSubject(this.buildSubject(message));
        email.setFrom(this.buildAddresses(message.getFrom()));
        email.setTo(this.buildAddresses(message.getRecipients(Message.RecipientType.TO)));
        email.setCc(this.buildAddresses(message.getRecipients(Message.RecipientType.CC)));
        email.setBcc(this.buildAddresses(message.getRecipients(Message.RecipientType.BCC)));
        email.setRecipients(this.buildAddresses(message.getAllRecipients()));
        email.setSentDate(this.formatDate(message.getSentDate()));
        email.setReceivedDate(this.formatDate(message.getReceivedDate()));
        email.setSimpleContents(this.buildSimpleContent(parts));
        email.setAttachments(this.buildAttachments(parts));
        email.setParts(this.buildEmailParts(parts));
        return email;
    }

    private String buildSubject(Message message) throws MessagingException {
        String subject = message.getSubject();
        if (StringUtils.isNotEmpty((CharSequence)subject)) {
            return subject;
        }
        return "";
    }

    private String buildAddresses(Address[] addresses) {
        ArrayList<String> list = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])addresses)) {
            for (Address address : addresses) {
                list.add(this.buildAddress(address));
            }
        }
        return StringUtils.join(list, (String)JOINER);
    }

    private String buildAddress(Address address) {
        return PlusEFakturaTools.decodeText(address.toString(), false, true);
    }

    private String formatDate(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            return dateFormat.format(date);
        }
        return "";
    }

    private String buildSimpleContent(List<Part> parts) {
        return StringUtils.defaultString((String)PlusEFakturaTools.getMessageContent(parts));
    }

    private List<EmailAttachment> buildAttachments(List<Part> parts) throws IOException, MessagingException {
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        if (CollectionUtils.isNotEmpty(parts)) {
            for (Part part : parts) {
                String fileName;
                String disposition = PlusEFakturaTools.getPartDisposition(part);
                if (!this.isAttachmentPart(disposition, fileName = PlusEFakturaTools.getPartFileName(part))) continue;
                attachments.add(this.buildAttachment(fileName, part.getSize()));
            }
        }
        return attachments;
    }

    private boolean isAttachmentPart(String disposition, String fileName) {
        return StringUtils.equalsIgnoreCase((CharSequence)disposition, (CharSequence)"attachment") || disposition == null && StringUtils.isNotBlank((CharSequence)fileName);
    }

    private EmailAttachment buildAttachment(String fileName, int size) {
        EmailAttachmentBuilderImpl builder = new EmailAttachmentBuilderImpl();
        return builder.build(fileName, size);
    }

    private List<EmailPart> buildEmailParts(List<Part> parts) throws IOException, MessagingException {
        ArrayList<EmailPart> emailParts = new ArrayList<EmailPart>();
        if (CollectionUtils.isNotEmpty(parts)) {
            for (Part part : parts) {
                emailParts.add(this.buildEmailPart(part));
            }
        }
        return emailParts;
    }

    private EmailPart buildEmailPart(Part part) throws MessagingException, IOException {
        EmailPartBuilderImpl builder = new EmailPartBuilderImpl();
        return builder.build(part);
    }
}

