/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class PasswordManager {
    private static final String ALGORITHM_NAME = "AES/GCM/NoPadding";
    private static final int ALGORITHM_NONCE_SIZE = 12;
    private static final int ALGORITHM_TAG_SIZE = 128;
    private static final int ALGORITHM_KEY_SIZE = 128;
    private static final String PBKDF2_NAME = "PBKDF2WithHmacSHA256";
    private static final int PBKDF2_SALT_SIZE = 16;
    private static final int PBKDF2_ITERATIONS = Short.MAX_VALUE;
    private static final String PASSWORD = "aA7rVANLGhtD";

    public static String encrypt(String input) throws Exception {
        SecureRandom rand = new SecureRandom();
        byte[] salt = new byte[16];
        rand.nextBytes(salt);
        PBEKeySpec pwSpec = new PBEKeySpec(PASSWORD.toCharArray(), salt, Short.MAX_VALUE, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBKDF2_NAME);
        byte[] key = keyFactory.generateSecret(pwSpec).getEncoded();
        byte[] ciphertextAndNonce = PasswordManager.encrypt(input.getBytes(StandardCharsets.UTF_8), key);
        byte[] ciphertextAndNonceAndSalt = new byte[salt.length + ciphertextAndNonce.length];
        System.arraycopy(salt, 0, ciphertextAndNonceAndSalt, 0, salt.length);
        System.arraycopy(ciphertextAndNonce, 0, ciphertextAndNonceAndSalt, salt.length, ciphertextAndNonce.length);
        return Base64.getEncoder().encodeToString(ciphertextAndNonceAndSalt);
    }

    private static byte[] encrypt(byte[] plaintext, byte[] key) throws Exception {
        SecureRandom rand = new SecureRandom();
        byte[] nonce = new byte[12];
        rand.nextBytes(nonce);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME);
        cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, nonce));
        byte[] ciphertext = cipher.doFinal(plaintext);
        byte[] ciphertextAndNonce = new byte[nonce.length + ciphertext.length];
        System.arraycopy(nonce, 0, ciphertextAndNonce, 0, nonce.length);
        System.arraycopy(ciphertext, 0, ciphertextAndNonce, nonce.length, ciphertext.length);
        return ciphertextAndNonce;
    }

    public static String decrypt(String input) throws Exception {
        byte[] ciphertextAndNonceAndSalt = Base64.getDecoder().decode(input);
        byte[] salt = new byte[16];
        byte[] ciphertextAndNonce = new byte[ciphertextAndNonceAndSalt.length - 16];
        System.arraycopy(ciphertextAndNonceAndSalt, 0, salt, 0, salt.length);
        System.arraycopy(ciphertextAndNonceAndSalt, salt.length, ciphertextAndNonce, 0, ciphertextAndNonce.length);
        PBEKeySpec pwSpec = new PBEKeySpec(PASSWORD.toCharArray(), salt, Short.MAX_VALUE, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBKDF2_NAME);
        byte[] key = keyFactory.generateSecret(pwSpec).getEncoded();
        return new String(PasswordManager.decrypt(ciphertextAndNonce, key), StandardCharsets.UTF_8);
    }

    private static byte[] decrypt(byte[] ciphertextAndNonce, byte[] key) throws Exception {
        byte[] nonce = new byte[12];
        byte[] ciphertext = new byte[ciphertextAndNonce.length - 12];
        System.arraycopy(ciphertextAndNonce, 0, nonce, 0, nonce.length);
        System.arraycopy(ciphertextAndNonce, nonce.length, ciphertext, 0, ciphertext.length);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME);
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, nonce));
        return cipher.doFinal(ciphertext);
    }
}

