/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.xpdl;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.efaktura.service.plugin.PluginService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class XpdlService {
    public static Logger log = Logger.getLogger(XpdlService.class);
    private static final String XPDL_FILE_NAME = "PlusEFaktura.xpdl";
    private static final String XPDL_FILE_CLASSPATH = "/xpdl/PlusEFaktura.xpdl";
    private static final String XPDL_PACKAGE_ID = "plusefaktura";
    private static final String XPDL_VERSION_PREFIX = ".v";
    @Autowired
    private PluginService pluginService;

    public void load() {
        Resource resource = this.pluginService.getResource(XPDL_FILE_CLASSPATH);
        if (resource.exists()) {
            try {
                String xpdlRepositoryPath = this.buildXpdlRepositoryPath();
                String xpdl = IOUtils.toString((InputStream)resource.getInputStream(), (String)"UTF-8");
                Package pack = XpdlPackageManager.getInstance().getPackage(XPDL_PACKAGE_ID);
                if (pack == null) {
                    this.generateXpdlFile(xpdl, xpdlRepositoryPath);
                    XpdlPackageManager.getInstance().loadPackage(xpdlRepositoryPath);
                } else if (this.areXpdlsDifferent(xpdlRepositoryPath, xpdl)) {
                    this.backupXpdl(xpdlRepositoryPath, pack);
                    this.generateXpdlFile(xpdl, xpdlRepositoryPath);
                    XpdlPackageManager.getInstance().updatePackage(pack.getId(), XPDL_FILE_NAME, true);
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void generateXpdlFile(String xpdl, String xpdlRepositoryPath) throws IOException {
        FileUtils.writeStringToFile((File)new File(xpdlRepositoryPath), (String)xpdl, (String)"UTF-8");
    }

    private String buildXpdlRepositoryPath() {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(XpdlPackageManager.getInstance().getFileNameByPackageId(XPDL_PACKAGE_ID));
        return path.toString();
    }

    private boolean areXpdlsDifferent(String xpdlRepositoryPath, String xpdl) throws IOException {
        String systemXpdl = FileUtils.readFileToString((File)new File(xpdlRepositoryPath), (String)"UTF-8");
        return !StringUtils.equals((CharSequence)systemXpdl, (CharSequence)xpdl);
    }

    private void backupXpdl(String xpdlRepositoryPath, Package pack) throws IOException {
        File srcFile = new File(xpdlRepositoryPath);
        File destFile = new File(this.buildXpdlBackupFilePath(xpdlRepositoryPath, pack));
        FileUtils.copyFile((File)srcFile, (File)destFile);
    }

    private String buildXpdlBackupFilePath(String xpdlRepositoryPath, Package pack) {
        StringBuilder name = new StringBuilder();
        name.append(xpdlRepositoryPath);
        name.append(XPDL_VERSION_PREFIX);
        name.append(pack.getInternalVersion());
        return name.toString();
    }
}

