/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.model.template.Template;
import com.suncode.plugin.efaktura.service.template.TemplateService;
import com.suncode.plugin.efaktura.service.xml.XmlAnalyzerService;
import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.TemplateVersion;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.Date;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ScheduledTask
public class SetTemplateVersionScheduledTask {
    public static Logger log = Logger.getLogger(SetTemplateVersionScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");
    @Autowired
    private TemplateService templateService;
    @Autowired
    private XmlAnalyzerService xmlAnalyzerService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-set-template-version-scheduled-task")).name("efaktura.scheduled-task.set-template-version.name")).description("efaktura.scheduled-task.set-template-version.description")).parameter().id("version").name("efaktura.scheduled-task.set-template-version.parameters.version.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String version) {
        log.info((Object)("**************** setTemplateVersionToAllTemplates(templateVersion=" + version + ") *****************"));
        long startTime = new Date().getTime();
        try {
            TemplateVersion templateVersion = TemplateVersion.getTemplateVersionByName(version);
            switch (templateVersion) {
                case PDFBOX_0_7_3: 
                case PDFBOX_1_7_1: {
                    this.setVersionToAll(templateVersion);
                    break;
                }
                default: {
                    throw new PlusEFakturaException("Nierozpoznana wersja szablonow: " + version);
                }
            }
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonania zadania ustawiania wersji dla szablonow: " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }

    private void setVersionToAll(TemplateVersion templateVersion) throws HibernateException, Exception {
        List<Template> templates = this.templateService.getAll();
        if (CollectionUtils.isNotEmpty(templates)) {
            log.info((Object)("Znaleziono " + templates.size() + " szablonow"));
            for (Template template : templates) {
                try {
                    this.setVersion(template, templateVersion);
                }
                catch (Exception exception) {
                    log.error((Object)("Wystapil blad podczas ustawiania wersji dla szablonu o id " + template.getId()));
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        } else {
            log.info((Object)"Nie znaleziono szablonow");
        }
    }

    private void setVersion(Template template, TemplateVersion templateVersion) throws TransformerException {
        long fileId = template.getTemplateDefinition().getFileId();
        FileService fileService = ServiceFactory.getFileService();
        WfFile file = fileService.getFile(Long.valueOf(fileId), new String[0]);
        if (file != null) {
            String path = file.getFullPath();
            Document doc = this.xmlAnalyzerService.getXmlFile(path);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            root.setAttribute("version", templateVersion.getName());
            this.xmlAnalyzerService.saveXml(doc, path);
        }
    }
}

