/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.scheduledtask;

import com.suncode.plugin.efaktura.util.PlusEFakturaTools;
import com.suncode.plugin.efaktura.util.exception.PlusEFakturaException;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class SaveTemplateDocumentClassScheduledTask {
    public static Logger log = Logger.getLogger(SaveTemplateDocumentClassScheduledTask.class);
    public static Logger clientLog = Logger.getLogger((String)"PlusEFakturaClientLog");

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("efaktura-save-template-document-class-scheduled-task")).name("efaktura.scheduled-task.save-template-document-class.name")).description("efaktura.scheduled-task.save-template-document-class.description")).parameter().id("documentClassName").name("efaktura.scheduled-task.save-template-document-class.parameters.document-class-name.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String documentClassName) {
        log.info((Object)("**************** saveTemplatesDocumentClass(documentClassName=" + documentClassName + ") *****************"));
        long startTime = new Date().getTime();
        String sProcessTypeName = "pefaktur";
        String sTaskTypeName = "templatesadministration";
        String sProcessFieldName = "templatesdocclass";
        try {
            log.info((Object)"Zapisywanie informacji o nazwie klasy dokumentow z szablonami faktur");
            if (StringUtils.isBlank((CharSequence)documentClassName)) {
                throw new PlusEFakturaException("Podaj nazwe klasy dokumentow");
            }
            DocumentClassService documentClassService = (DocumentClassService)SpringContext.getBean(DocumentClassService.class);
            DocumentClass documentClass = documentClassService.getDocumentClass(documentClassName, new String[0]);
            if (documentClass == null) {
                throw new PlusEFakturaException("Klasa dokumentow " + documentClassName + " nie istnieje w systemie");
            }
            ProcessDataService processDataService = (ProcessDataService)SpringContext.getBean(ProcessDataService.class);
            processDataService.saveProcessData(sProcessTypeName, sTaskTypeName, sProcessFieldName, documentClassName);
        }
        catch (PlusEFakturaException exception) {
            log.warn((Object)exception.getMessage());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas trwania procesu dodawania informacji o klasie dokumentow dla szablonow faktur o nazwie " + documentClassName + ": " + PlusEFakturaTools.formatDuration(stopTime - startTime)));
    }
}

