/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.model.report;

import com.suncode.plugin.efaktura.model.report.OldReport;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="pm_efaktura_report")
@SequenceGenerator(name="efaktura_report", sequenceName="pm_efaktura_report_id")
public class Report
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="efaktura_report")
    private Long id;
    @Column
    private String supplier;
    @Column(name="email_id")
    private String emailId;
    @Column(name="date_of_read")
    private Date dateOfRead;
    @Column
    private String status;
    @Column
    private Boolean forwarded;
    @Column
    private Boolean deleted;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public Date getDateOfRead() {
        return this.dateOfRead;
    }

    public void setDateOfRead(Date dateOfRead) {
        this.dateOfRead = dateOfRead;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getForwarded() {
        return this.forwarded;
    }

    public void setForwarded(Boolean forwarded) {
        this.forwarded = forwarded;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public static Report fromOldReport(OldReport oldReport) {
        Report report = new Report();
        report.setSupplier(oldReport.getSupplier());
        report.setEmailId(oldReport.getEmailId());
        report.setDateOfRead(oldReport.getDateOfRead());
        report.setStatus(oldReport.getStatus());
        report.setForwarded(Boolean.parseBoolean(oldReport.getForwarded()));
        report.setDeleted(Boolean.parseBoolean(oldReport.getDeleted()));
        return report;
    }
}

