/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.seenmail;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.seenmail.SeenMailDao;
import com.suncode.plugin.efaktura.model.seenmail.OldSeenMail;
import com.suncode.plugin.efaktura.model.seenmail.SeenMail;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;

@Repository
public class SeenMailDaoImpl
extends EfakturaHibernateEditableDao<SeenMail, Long>
implements SeenMailDao {
    private static final String OLD_SEEN_MAIL_TABLE_NAME = "pm_plusefaktura_seenmails";
    private static final String FIND_ALL_OLD_SEEN_MAILS_QUERY = "select email, messageuid, dateofread, attachmentmessageid from pm_plusefaktura_seenmails";

    @Override
    public List<SeenMail> findAllByEmailAndMessageUids(String email, List<String> messageUids) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SeenMail.class);
        criteria.add((Criterion)Restrictions.eq((String)"email", (Object)email));
        criteria.add(Restrictions.in((String)"messageUid", messageUids));
        return this.findByCriteria(criteria);
    }

    @Override
    public Optional<SeenMail> findByEmailAndMessageUid(String email, String messageUid) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SeenMail.class);
        criteria.add((Criterion)Restrictions.eq((String)"email", (Object)email));
        criteria.add((Criterion)Restrictions.eq((String)"messageUid", (Object)messageUid));
        return Optional.ofNullable((SeenMail)this.findOne(criteria));
    }

    @Override
    public void deleteAllByEmail(String email) {
        DetachedCriteria criteria = DetachedCriteria.forClass(SeenMail.class);
        criteria.add((Criterion)Restrictions.eq((String)"email", (Object)email));
        for (SeenMail seenMail : this.findByCriteria(criteria)) {
            this.delete(seenMail);
        }
    }

    @Override
    public List<OldSeenMail> findAllOldSeenMails() {
        if (this.doesOldTableExist()) {
            return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<OldSeenMail>>(){

                public List<OldSeenMail> execute(Connection connection) throws SQLException {
                    PreparedStatement statement = connection.prepareStatement(SeenMailDaoImpl.FIND_ALL_OLD_SEEN_MAILS_QUERY);
                    ResultSet resultSet = statement.executeQuery();
                    ArrayList<OldSeenMail> oldSeenMails = new ArrayList<OldSeenMail>();
                    while (resultSet.next()) {
                        oldSeenMails.add(SeenMailDaoImpl.this.buildOldSeenMail(resultSet));
                    }
                    return oldSeenMails;
                }
            });
        }
        return new ArrayList<OldSeenMail>();
    }

    private boolean doesOldTableExist() {
        return HibernateUtil.tableExists((String)OLD_SEEN_MAIL_TABLE_NAME);
    }

    private OldSeenMail buildOldSeenMail(ResultSet resultSet) throws SQLException {
        OldSeenMail oldSeenMail = new OldSeenMail();
        oldSeenMail.setEmail(resultSet.getString(1));
        oldSeenMail.setMessageUid(resultSet.getString(2));
        oldSeenMail.setDateOfRead(resultSet.getDate(3));
        oldSeenMail.setAttachmentMessageId(resultSet.getString(4));
        return oldSeenMail;
    }
}

