/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.service.mailtocopy;

import com.suncode.plugin.efaktura.dao.mailtocopy.MailToCopyDao;
import com.suncode.plugin.efaktura.model.mailtocopy.MailToCopy;
import com.suncode.plugin.efaktura.util.mailtocopy.UidTypePair;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailToCopyService {
    @Autowired
    private MailToCopyDao mailToCopyDao;

    @Transactional
    public long add(MailToCopy mailToCopy) {
        return (Long)this.mailToCopyDao.save(mailToCopy);
    }

    @Transactional
    public void remove(String email, String messageUid) {
        MailToCopy mailToCopy = this.mailToCopyDao.findByEmailAndMessageUid(email, messageUid);
        if (mailToCopy != null) {
            this.mailToCopyDao.delete(mailToCopy);
        }
    }

    @Transactional(readOnly=true)
    public List<UidTypePair> getMessageUidTypePairs(String email) {
        return this.mailToCopyDao.findAllByEmail(email).stream().map(MailToCopyService::toUidTypePair).collect(Collectors.toList());
    }

    private static UidTypePair toUidTypePair(MailToCopy mailToCopy) {
        UidTypePair pair = new UidTypePair();
        pair.setMessageUid(mailToCopy.getMessageUid());
        pair.setMailType(mailToCopy.getMailType());
        return pair;
    }
}

