/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.model.editopdf;

import com.suncode.plugin.efaktura.model.editopdf.OldEdiToPdf;
import com.suncode.plugin.efaktura.util.EdiType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.Serializable;
import org.hibernate.annotations.Type;

@Entity
@Table(name="pm_efaktura_edi_to_pdf", uniqueConstraints={@UniqueConstraint(columnNames={"email_from"})})
@SequenceGenerator(name="efaktura_edi_to_pdf", sequenceName="pm_efaktura_edi_to_pdf_id")
public class EdiToPdf
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="efaktura_edi_to_pdf")
    private Long id;
    @Column(name="email_from")
    private String emailFrom;
    @Column(name="edi_type")
    @Type(type="com.suncode.plugin.efaktura.model.editopdf.EdiTypeEnum")
    private EdiType ediType;
    @Column(name="template_path", length=1024)
    private String templatePath;
    @Column(name="docx_to_pdf_converter_type")
    private String docxToPdfConverterType;
    @Column(name="file_name")
    private String fileName;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public EdiType getEdiType() {
        return this.ediType;
    }

    public void setEdiType(EdiType ediType) {
        this.ediType = ediType;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getDocxToPdfConverterType() {
        return this.docxToPdfConverterType;
    }

    public void setDocxToPdfConverterType(String docxToPdfConverterType) {
        this.docxToPdfConverterType = docxToPdfConverterType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static EdiToPdf fromOldEdiToPdf(OldEdiToPdf oldEdiToPdf) {
        EdiToPdf ediToPdf = new EdiToPdf();
        ediToPdf.setEmailFrom(oldEdiToPdf.getFromEmail());
        ediToPdf.setEdiType(EdiType.getByName(oldEdiToPdf.getEdiType()));
        ediToPdf.setTemplatePath(oldEdiToPdf.getTemplatePath());
        ediToPdf.setDocxToPdfConverterType(oldEdiToPdf.getDocxToPdfConverterType());
        ediToPdf.setFileName(oldEdiToPdf.getFileName());
        return ediToPdf;
    }
}

