/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.dao.template;

import com.suncode.plugin.efaktura.dao.EfakturaHibernateEditableDao;
import com.suncode.plugin.efaktura.dao.template.EmailFromDao;
import com.suncode.plugin.efaktura.model.template.EmailFrom;
import com.suncode.pwfl.search.SortDirection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class EmailFromDaoImpl
extends EfakturaHibernateEditableDao<EmailFrom, Long>
implements EmailFromDao {
    @Override
    public List<String> findKnownEmailsFrom(String query, String emailFrom, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        DetachedCriteria dc = DetachedCriteria.forClass(EmailFrom.class);
        dc.add(Restrictions.ilike((String)"emailFrom", (String)query, (MatchMode)MatchMode.ANYWHERE));
        dc.add(Restrictions.ilike((String)"emailFrom", (String)emailFrom, (MatchMode)MatchMode.ANYWHERE));
        dc.setProjection(Projections.distinct((Projection)Projections.property((String)"emailFrom")));
        dc.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        Criteria criteria = dc.getExecutableCriteria(this.getSession());
        if (limit != null) {
            criteria.setMaxResults(limit.intValue());
        }
        if (start != null) {
            criteria.setFirstResult(start.intValue());
        }
        return criteria.list();
    }

    @Override
    public long getKnownEmailsCount(String query, String emailFrom) {
        DetachedCriteria dc = DetachedCriteria.forClass(EmailFrom.class);
        dc.add(Restrictions.ilike((String)"emailFrom", (String)query, (MatchMode)MatchMode.ANYWHERE));
        dc.add(Restrictions.ilike((String)"emailFrom", (String)emailFrom, (MatchMode)MatchMode.ANYWHERE));
        dc.setProjection((Projection)Projections.countDistinct((String)"emailFrom"));
        return (Long)dc.getExecutableCriteria(this.getSession()).uniqueResult();
    }
}

