SuncodeFormService.addOnReadyEvent( plusEFaktura_onFormLoad );

function plusEFaktura_onFormLoad() {
	plusEFaktura_importCss( PW.getAbsolutePath( 'plugin/com.suncode.plugin-efaktura/resources/style/efaktura.css' ) );
	plusEFaktura_importCss( PW.getAbsolutePath( 'plugin/com.suncode.plugin-efaktura/resources/style/fileuploadfield.css' ) );
	
    var variableService = ServiceFactory.getVariableService();
    var templateIdField = variableService.get( 'template_id' );
    if ( !Ext4.isEmpty( templateIdField ) ) {
        templateIdField.inputEl.set( {
            readonly: true
        } );
    }

    variableService.setValue( 'system_url', window.plusEFaktura_getUrl() );
    var emailFromHiddenSet = variableService.get( 'email_from_hidden_set' );

    if ( !Ext4.isEmpty( emailFromHiddenSet ) ) {
        var lastValue = emailFromHiddenSet.getValue();
        window.setInterval( function() {
            var newValue = emailFromHiddenSet.getValue();

            if ( newValue != lastValue ) {
            	var data = new Array();
            	var tab = newValue.split( ', ' );
            	
            	for ( var i = 0; i < tab.length; i++ ) {
            		data.push( {
                        email_from: tab[i]
                    } );
            	}
            	
            	var variableSetService = ServiceFactory.getVariableSetService();
                var variableSet = variableSetService.get( 0 );
                var store = variableSet.getStore();
                store.add( data );
                lastValue = '';
                emailFromHiddenSet.setValue( '' );
            }
        }, 500 );
    }

    var instruction = variableService.get( 'info_start' );

    if ( !Ext4.isEmpty( instruction ) ) {
      switch ( Suncode.getUserLocale() ) {
        case 'pl':
          instruction.setValue( 'Podaj adres e-mail dostawcy i ewentualne kryteria oraz załącz w dokumentach procesu jeden szablon XML faktury do klasy szablonów' );
          break;
        default:
          instruction.setValue( 'Type supplier e-mail address and criteria and attach to process one xml invoice template to templates document class' );
          break;
      }
    }

}

window.plusEFaktura_importCss = function( href ) {
	var head = document.getElementsByTagName( 'head' )[0];
    var link = document.createElement( 'link' );
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.href = href;
    link.media = 'all';
    head.appendChild( link );
}

window.plusEFaktura_getUrl = function() {
    var url = [ document.location.protocol, '//', document.location.host, document.location.pathname ].join( '' );
    var lastSymbol = url.lastIndexOf( '/' );
    if ( lastSymbol != 0 && lastSymbol != -1 ) {
        url = url.substring( 0, lastSymbol );
    }

    return url;
}

window.plusEFaktura_downloadTemplate = function( fileId ) {
    window.open( window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/template/download/' + fileId, 'Download' );
}

window.plusEFaktura_showAttachmentsManager = function( oButton ) {
    Ext4.Ajax.request( {
        url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/attachment/getTranslations',
        method: 'GET',
        success: function( response, opts ) {
            var responseJson = Ext4.JSON.decode( response.responseText );
            window.plusEFaktura_executeShowAttachmentsManager( responseJson.translations );
        },
        failure: function( response, opts ) {
            Ext4.Msg.show( {
                title: 'Error',
                msg: 'Error occured.',
                buttons: Ext4.Msg.OK,
                icon: Ext4.Msg.ERROR
            } );
        }
    } );
}

window.plusEFaktura_executeShowAttachmentsManager = function( translations ) {
    var variableSetService = ServiceFactory.getVariableSetService();
    var variableSet = variableSetService.get( 0 );
    var store = variableSet.getStore();

    if ( store.getCount() == 0 ) {
        Ext4.Msg.show( {
            title: translations.warning,
            msg: translations.no_supplier_emails,
            buttons: Ext4.Msg.OK,
            icon: Ext4.Msg.WARNING
        } );
        return;
    }

    window.plusEFaktura_extOverrides();

    var attachmentsManager = new Ext.ux.plusmpm.AttachmentsManagerWindow( {
        translations: translations,
        fromEmailsStore: store
    } );
    attachmentsManager.show();
}

window.plusEFaktura_extOverrides = function() {
    Ext.override( Ext.form.Field, {
        setFieldLabel: function( text ) {
            if ( this.rendered ) {
                var labelSeparator = this.initialConfig.labelSeparator ? this.initialConfig.labelSeparator : ':';
                this.getEl().up( '.x-form-item', 10, true ).child( '.x-form-item-label' ).update( text + labelSeparator );
            }

            this.fieldLabel = text;
        }
    } );
}

Ext.ux.plusmpm.AttachmentsManagerWindow = function( config ) {
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: size.width * 0.8,
        height: size.height * 0.8,
        title: config.translations.attachments_manager,
        layout: 'border',
        defaults: {
            split: true
        },
        items: [ new Ext.ux.plusmpm.AttachmentsManagerTree( config ), new Ext.ux.plusmpm.AttachmentsManagerPanel( config ) ],
        closable: true
    }, config );

    Ext.ux.plusmpm.AttachmentsManagerWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.AttachmentsManagerWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.plusmpm.AttachmentsManagerWindow.superclass.initComponent.call( this );
    }
} );

Ext.ux.plusmpm.AttachmentsManagerTree = function( config ) {
    var translations = config.translations;
    var store = config.fromEmailsStore;
    var fromEmails = '';

    for ( var i = 0; i < store.getCount(); i++ ) {
        var rec = store.getAt( i );
        var fromEmail = rec.get( 'email_from' );

        if ( i < store.getCount() - 1 ) {
            fromEmails += fromEmail + ';';
        } else {
            fromEmails += fromEmail;
        }
    }

    config = Ext.apply( {
        title: translations.services,
        region: 'west',
        layout: 'fit',
        collapsible: true,
        titleCollapse: true,
        width: 300,
        useArrows: true,
        autoScroll: true,
        containerScroll: true,
        frame: true,
        ref: 'attachmentServicesTree',
        loader: new Ext.tree.TreeLoader( {
            dataUrl: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/attachment/read',
            requestMethod: 'GET',
            baseParams: {
                fromEmails: fromEmails
            }
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: translations.available_services,
            icon: 'style/img/fam/database.png',
            expanded: true,
            leaf: false
        } )
    }, config );

    Ext.ux.plusmpm.AttachmentsManagerTree.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.AttachmentsManagerTree, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.plusmpm.AttachmentsManagerTree.superclass.initComponent.call( this );

        this.on( 'click', this.loadAttachmentService, this );
    },
    loadAttachmentService: function( node, deep, anim ) {
        var form = this.ownerCt.attachmentServiceDef.getForm();

        if ( node.attributes.isEmail ) {
            this.ownerCt.attachmentServiceDef.performClear();
            form.findField( 'fromEmail' ).setValue( node.attributes.fromEmail );
        } else if ( node.attributes.isService ) {
            this.ownerCt.attachmentServiceDef.performClear();
            form.findField( 'fromEmail' ).setValue( node.attributes.fromEmail );
            var detectionTypeField = form.findField( 'detectionTypeValue' );
            detectionTypeField.setValue( node.attributes.detectionType );
            detectionTypeField.fireEvent( 'select', detectionTypeField );
            var detectionValueField = form.findField( 'detectionValueValue' );
            if ( !Ext.isEmpty( detectionValueField ) ) {
              detectionValueField.setValue( node.attributes.detectionValue );
            }
            var actionTypeField = form.findField( 'actionTypeValue' );
            actionTypeField.setValue( node.attributes.actionType );
            actionTypeField.fireEvent( 'select', actionTypeField );
            var actionValueField = form.findField( 'actionValueValue' );
            if ( !Ext.isEmpty( actionValueField ) ) {
                actionValueField.setValue( node.attributes.actionValue );
            }
            form.findField( 'actionId' ).setValue( node.attributes.actionId );
        }
    }
} );

Ext.ux.plusmpm.AttachmentsManagerPanel = function( config ) {
    var translations = config.translations;
    var detectionTypesArray = [ [ 'TEMPLATEMISMATCH', translations.template_mismatch ], [ 'PHRASEINFILENAME', translations.phrase_in_filename ],
                    [ 'PHRASENOTINFILENAME', translations.phrase_not_in_filename ], [ 'PHRASEINCONTENT', translations.phrase_in_content ],
                    [ 'PHRASENOTINCONTENT', translations.phrase_not_in_content ] ];
    var actionTypesArray = [ [ 'ADDTODOCCLASS', translations.add_to_doc_class ], [ 'IGNORE', translations.ignore ] ];

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        region: 'center',
        autoScroll: true,
        labelWidth: 200,
        frame: true,
        border: false,
        buttonAlign: 'center',
        ref: 'attachmentServiceDef',
        items: [ {
            xtype: 'textfield',
            name: 'fromEmail',
            inputType: 'text',
            anchor: '100%',
            fieldLabel: translations.supplier_email,
            labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
            readOnly: true
        }, {
            xtype: 'combo',
            triggerAction: 'all',
            fieldLabel: translations.detection,
            labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
            name: 'actionType',
            anchor: '100%',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'detectionType', 'detectionTypeName' ],
                data: detectionTypesArray
            } ),
            submitValue: true,
            hiddenName: 'detectionTypeValue',
            valueField: 'detectionType',
            displayField: 'detectionTypeName',
            forceSelection: true,
            editable: false,
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var detectionValueField = this.getForm().findField( 'detectionValueValue' );

                    switch ( combo.getValue() ) {
                        case 'PHRASEINCONTENT':
                        case 'PHRASENOTINCONTENT':
                        case 'PHRASEINFILENAME':
                        case 'PHRASENOTINFILENAME':
                            if ( !Ext.isEmpty( detectionValueField ) ) {
                              this.remove( detectionValueField );
                            }
                            this.insert( 2, new Ext.form.TextField( {
                              fieldLabel: translations.phrase,
                              name: 'detectionValueValue',
                              anchor: '100%',
                              labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;'
                            } ) );
                            break;
                        default:
                            if ( !Ext.isEmpty( detectionValueField ) ) {
                              this.remove( detectionValueField );
                            }
                            break;
                    }

                    this.doLayout();
                }
            }
        }, {
            xtype: 'combo',
            triggerAction: 'all',
            fieldLabel: translations.action_type,
            labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
            name: 'actionType',
            anchor: '100%',
            mode: 'local',
            store: new Ext.data.ArrayStore( {
                fields: [ 'actionType', 'actionTypeName' ],
                data: actionTypesArray
            } ),
            submitValue: true,
            hiddenName: 'actionTypeValue',
            valueField: 'actionType',
            displayField: 'actionTypeName',
            forceSelection: true,
            editable: false,
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var actionValueField = this.getForm().findField( 'actionValueValue' );

                    switch ( combo.getValue() ) {
                        case 'ADDTODOCCLASS':
                            if ( !Ext.isEmpty( actionValueField ) ) {
                                this.remove( actionValueField );
                            }
                            this.add( new Ext.ux.plusmpm.SystemDocumentClassesChooser( {
                                fieldLabel: translations.doc_class,
                                forceSelection: false,
                                hiddenName: 'actionValueValue'
                            } ) );
                            break;
                        default:
                            if ( !Ext.isEmpty( actionValueField ) ) {
                                this.remove( actionValueField );
                            }
                            break;
                    }

                    this.doLayout();
                }
            }
        }, {
            xtype: 'textfield',
            name: 'actionId',
            inputType: 'text',
            hidden: true
        } ],
        buttons: [ {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/add.png',
            text: translations.create,
            handler: this.createAction,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/arrow_refresh.png',
            text: translations.update,
            handler: this.updateAction,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/delete.png',
            text: translations.remove,
            handler: this.removeAction,
            scope: this
        } ]
    }, config );

    Ext.ux.plusmpm.AttachmentsManagerPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.AttachmentsManagerPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.plusmpm.AttachmentsManagerPanel.superclass.initComponent.call( this );
    },
    createAction: function() {
        this.handleAction( 'create' );
    },
    updateAction: function() {
        this.handleAction( 'update' );
    },
    removeAction: function() {
        this.handleAction( 'delete' );
    },
    handleAction: function( action ) {
        this.getForm().submit( {
            url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/attachment/' + action,
            method: 'POST',
            scope: this,
            success: function( form, action ) {
                var responseJson = Ext.util.JSON.decode( action.response.responseText );

                Ext.Msg.show( {
                    title: this.initialConfig.translations.success,
                    msg: responseJson.message,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.INFO
                } );

                if ( responseJson.actionPerformed ) {
                    this.performClear();
                    this.ownerCt.attachmentServicesTree.getRootNode().reload();
                }
            },
            failure: function( form, action ) {
                if ( !Ext.isDefined( action.response ) ) {
                    Ext.Msg.show( {
                        title: this.initialConfig.translations.error,
                        msg: this.initialConfig.translations.error + '.',
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.WARNING
                    } );
                } else {
                    var responseJson = Ext.util.JSON.decode( action.response.responseText );

                    Ext.Msg.show( {
                        title: this.initialConfig.translations.warning,
                        msg: responseJson.message,
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.WARNING
                    } );
                }
            }
        } );
    },
    performClear: function() {
        this.getForm().reset();
        var detectionValueField = this.getForm().findField( 'detectionValueValue' );
        if ( !Ext.isEmpty( detectionValueField ) ) {
          this.remove( detectionValueField );
          this.doLayout();
        }
        var actionValueField = this.getForm().findField( 'actionValueValue' );
        if ( !Ext.isEmpty( actionValueField ) ) {
            this.remove( actionValueField );
            this.doLayout();
        }
    }
} );

Ext.ux.plusmpm.SystemDocumentClassesChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/documentclass/read'
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data'
    } );

    config = Ext.apply( {
        displayField: 'name',
        valueField: 'name',
        labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
        store: store,
        triggerAction: 'all',
        mode: 'remote',
        lazyInit: false,
        anchor: '100%',
        resizable: true
    }, config );

    Ext.ux.plusmpm.SystemDocumentClassesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.SystemDocumentClassesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.plusmpm.SystemDocumentClassesChooser.superclass.initComponent.call( this );
    }
} );

window.plusEFaktura_showEdiToPdfsManager = function( oButton ) {
    Ext4.Ajax.request( {
    	url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/getTranslations',
        method: 'GET',
        success: function( response, opts ) {
            var responseJson = Ext4.JSON.decode( response.responseText );
            window.plusEFaktura_executeShowEdiToPdfsManager( responseJson.translations );
        },
        failure: function( response, opts ) {
            Ext4.Msg.show( {
                title: 'Error',
                msg: 'Error occured.',
                buttons: Ext4.Msg.OK,
                icon: Ext4.Msg.ERROR
            } );
        }
    } );
}

window.plusEFaktura_executeShowEdiToPdfsManager = function( translations ) {
    var variableSetService = ServiceFactory.getVariableSetService();
    var variableSet = variableSetService.get( 0 );
    var store = variableSet.getStore();

    if ( store.getCount() == 0 ) {
        Ext4.Msg.show( {
            title: translations.warning,
            msg: translations.no_supplier_emails,
            buttons: Ext4.Msg.OK,
            icon: Ext4.Msg.WARNING
        } );
        return;
    }

    window.plusEFaktura_extOverrides();

    var ediToPdfsManager = new Ext.ux.plusmpm.EdiToPdfsManagerWindow( {
        translations: translations,
        fromEmailsStore: store
    } );
    ediToPdfsManager.show();
}

Ext.ux.plusmpm.EdiToPdfsManagerWindow = function( config ) {
    var translations = config.translations;
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: size.width * 0.8,
        height: size.height * 0.8,
        title: translations.edi_to_pdf_manager,
        layout: 'border',
        defaults: {
            split: true
        },
        items: [ new Ext.ux.plusmpm.EdiToPdfsManagerTree( config ), new Ext.ux.plusmpm.EdiToPdfsManagerPanel( config ) ],
        closable: true
    }, config );

    Ext.ux.plusmpm.EdiToPdfsManagerWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.EdiToPdfsManagerWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.plusmpm.EdiToPdfsManagerWindow.superclass.initComponent.call( this );
    }
} );

Ext.ux.plusmpm.EdiToPdfsManagerTree = function( config ) {
    var translations = config.translations;
    var store = config.fromEmailsStore;
    var fromEmails = '';

    for ( var i = 0; i < store.getCount(); i++ ) {
        var rec = store.getAt( i );
        var fromEmail = rec.get( 'email_from' );

        if ( i < store.getCount() - 1 ) {
            fromEmails += fromEmail + ';';
        } else {
            fromEmails += fromEmail;
        }
    }

    config = Ext.apply( {
        title: translations.conversions,
        region: 'west',
        layout: 'fit',
        collapsible: true,
        titleCollapse: true,
        width: 300,
        useArrows: true,
        autoScroll: true,
        containerScroll: true,
        frame: true,
        ref: 'ediToPdfConversionsTree',
        loader: new Ext.tree.TreeLoader( {
        	dataUrl: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/read',
            requestMethod: 'GET',
            baseParams: {
                fromEmails: fromEmails
            }
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: translations.available_conversions,
            icon: 'style/img/fam/database.png',
            expanded: true,
            leaf: false
        } )
    }, config );

    Ext.ux.plusmpm.EdiToPdfsManagerTree.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.EdiToPdfsManagerTree, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.plusmpm.EdiToPdfsManagerTree.superclass.initComponent.call( this );

        this.on( 'click', this.loadEdiToPdfConversion, this );
    },
    loadEdiToPdfConversion: function( node, deep, anim ) {
        var form = this.ownerCt.ediToPdfConversionDef.getForm();

        if ( node.attributes.isEmail ) {
            this.ownerCt.ediToPdfConversionDef.performClear();
            form.findField( 'fromEmail' ).setValue( node.attributes.fromEmail );
        } else if ( node.attributes.isConversion ) {
            this.ownerCt.ediToPdfConversionDef.performClear();
            form.findField( 'fromEmail' ).setValue( node.attributes.fromEmail );
            form.findField( 'ediType' ).setValue( node.attributes.ediType );
            form.findField( 'docxToPdfConverterType' ).setValue( node.attributes.docxToPdfConverterType );
            form.findField( 'conversionId' ).setValue( node.attributes.conversionId );
        }
    }
} );

Ext.ux.plusmpm.EdiToPdfsManagerPanel = function( config ) {
    var translations = config.translations;

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        region: 'center',
        autoScroll: true,
        labelWidth: 200,
        frame: true,
        border: false,
        buttonAlign: 'center',
        ref: 'ediToPdfConversionDef',
        fileUpload: true,
        standardSubmit: false,
        items: [ {
            xtype: 'textfield',
            name: 'fromEmail',
            inputType: 'text',
            anchor: '100%',
            fieldLabel: translations.supplier_email,
            labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
            readOnly: true
        }, new Ext.ux.plusmpm.EdiTypesChooser( {
            translations: translations
        } ), {
            xtype: 'fileuploadfield',
            fieldLabel: translations.template,
            labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
            name: 'template',
            buttonText: translations.choose,
            anchor: '100%',
            allowBlank: false,
            blankText: translations.choose_file,
            regex: new RegExp( '.docx$', 'i' ),
            regexText: translations.chosen_file_is_not_docx
        }, new Ext.ux.plusmpm.DocxToPdfConverterTypesChooser( {
            translations: translations
        } ), new Ext.ux.plusmpm.SystemDocumentClassesChooser( {
            fieldLabel: translations.template_doc_class,
            forceSelection: true,
            hiddenName: 'documentClassName',
            allowBlank: false,
            blankText: translations.choose_doc_class
        } ), {
            xtype: 'textfield',
            name: 'conversionId',
            inputType: 'text',
            hidden: true
        } ],
        buttons: [ {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/add.png',
            text: translations.create,
            handler: this.createAction,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/arrow_refresh.png',
            text: translations.update,
            handler: this.updateAction,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/delete.png',
            text: translations.remove,
            handler: this.removeAction,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/page_white_go.png',
            text: translations.download_template,
            handler: this.downloadTemplate,
            scope: this
        }, {
            cls: 'x-btn-icon-text',
            icon: 'style/img/fam/page_white_acrobat.png',
            text: translations.convert_invoice,
            handler: this.convertInvoice,
            scope: this
        } ]
    }, config );

    Ext.ux.plusmpm.EdiToPdfsManagerPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.EdiToPdfsManagerPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.plusmpm.EdiToPdfsManagerPanel.superclass.initComponent.call( this );
    },
    createAction: function() {
        this.handleAction( 'create' );
    },
    updateAction: function() {
        this.handleAction( 'update' );
    },
    removeAction: function() {
    	var conversionId = this.getForm().findField( 'conversionId' ).getValue();

        Ext.Ajax.request( {
            url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/delete/' + conversionId,
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var responseJson = Ext.util.JSON.decode( response.responseText );

                Ext.Msg.show( {
                    title: this.initialConfig.translations.success,
                    msg: responseJson.message,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.INFO
                } );

                if ( responseJson.actionPerformed ) {
                    this.performClear();
                    this.ownerCt.ediToPdfConversionsTree.getRootNode().reload();
                }
            },
            failure: function( response, opts ) {
                if ( !Ext.isDefined( response ) ) {
                    Ext.Msg.show( {
                        title: this.initialConfig.translations.error,
                        msg: this.initialConfig.translations.error + '.',
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.WARNING
                    } );
                } else {
                    var responseJson = Ext.util.JSON.decode( response.responseText );

                    Ext.Msg.show( {
                        title: this.initialConfig.translations.warning,
                        msg: responseJson.message,
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.WARNING
                    } );
                }
            }
        } );
    },
    handleAction: function( action ) {
        var form = this.getForm();

        if ( form.isValid() ) {
            form.submit( {
                url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/' + action,
                method: 'POST',
                scope: this,
                success: function( form, action ) {
                    Ext.Msg.show( {
                        title: this.initialConfig.translations.success,
                        msg: action.result.message,
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.INFO
                    } );

                    if ( action.result.actionPerformed ) {
                        this.performClear();
                        this.ownerCt.ediToPdfConversionsTree.getRootNode().reload();
                    }
                },
                failure: function( form, action ) {
                    if ( !Ext.isDefined( action.result ) ) {
                        Ext.Msg.show( {
                            title: this.initialConfig.translations.error,
                            msg: this.initialConfig.translations.error + '.',
                            buttons: Ext.Msg.OK,
                            icon: Ext.Msg.WARNING
                        } );
                    } else {
                        Ext.Msg.show( {
                            title: this.initialConfig.translations.warning,
                            msg: action.result.message,
                            buttons: Ext.Msg.OK,
                            icon: Ext.Msg.WARNING
                        } );
                    }
                }
            } );
        }
    },
    downloadTemplate: function() {
        var translations = this.initialConfig.translations;
        var conversionId = this.getForm().findField( 'conversionId' ).getValue();

        if ( Ext.isEmpty( conversionId ) ) {
            Ext.Msg.show( {
                title: translations.warning,
                msg: translations.choose_conversion,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            } );
        } else {
        	window.open( window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/downloadTemplate/'
        			+ conversionId, 'Download' );
        }
    },
    convertInvoice: function() {
        var translations = this.initialConfig.translations;
        var conversionId = this.getForm().findField( 'conversionId' ).getValue();

        if ( Ext.isEmpty( conversionId ) ) {
            Ext.Msg.show( {
                title: translations.warning,
                msg: translations.choose_conversion,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            } );
        } else {
            var win = new Ext.ux.plusmpm.EdiToPdfInvoiceConverterWindow( {
                translations: translations,
                conversionId: conversionId
            } );
            win.show();
        }
    },
    performClear: function() {
        this.getForm().reset();
    }
} );

Ext.ux.plusmpm.EdiTypesChooser = function( config ) {
    var translations = config.translations;
    var types = [ [ 'UN/EDIFACT D96A' ] ];

    config = Ext.apply( {
        triggerAction: 'all',
        fieldLabel: translations.edi_file_type,
        labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
        mode: 'local',
        anchor: '100%',
        store: new Ext.data.ArrayStore( {
            fields: [ 'type' ],
            data: types
        } ),
        submitValue: true,
        hiddenName: 'ediType',
        valueField: 'type',
        displayField: 'type',
        forceSelection: true,
        editable: false
    }, config );

    Ext.ux.plusmpm.EdiTypesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.EdiTypesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.plusmpm.EdiTypesChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.plusmpm.DocxToPdfConverterTypesChooser = function( config ) {
    var translations = config.translations;
    var types = [ [ 'Docx4J' ], [ 'Office' ] ];

    config = Ext.apply( {
        allowBlank: false,
        triggerAction: 'all',
        fieldLabel: translations.template_to_pdf_converter_type,
        labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
        mode: 'local',
        anchor: '100%',
        store: new Ext.data.ArrayStore( {
            fields: [ 'type' ],
            data: types
        } ),
        submitValue: true,
        hiddenName: 'docxToPdfConverterType',
        valueField: 'type',
        displayField: 'type',
        forceSelection: false
    }, config );

    Ext.ux.plusmpm.DocxToPdfConverterTypesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.DocxToPdfConverterTypesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.plusmpm.DocxToPdfConverterTypesChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.plusmpm.EdiToPdfInvoiceConverterWindow = function( config ) {
    var translations = config.translations;
    var conversionId = config.conversionId;

    config = Ext.apply( {
        modal: true,
        autoWidth: true,
        autoHeight: true,
        title: translations.invoices_converter,
        items: [ {
            xtype: 'form',
            fileUpload: true,
            standardSubmit: true,
            url: window.plusEFaktura_getUrl() + '/plugin/com.suncode.plugin-efaktura/api/editopdf/convertInvoice',
            width: 400,
            labelWidth: 100,
            frame: true,
            buttonAlign: 'center',
            ref: 'converterPanel',
            items: [ {
                xtype: 'fileuploadfield',
                fieldLabel: translations.invoice,
                labelStyle: 'margin-top:0.25em; margin-bottom:0.25em;',
                name: 'invoice',
                buttonText: translations.choose,
                anchor: '100%',
                allowBlank: false,
                blankText: translations.choose_file,
                regex: new RegExp( '.edi$', 'i' ),
                regexText: translations.chosen_file_is_not_edi
            }, {
                xtype: 'fieldset',
                hidden: true,
                items: [ {
                    xtype: 'textfield',
                    name: 'conversionId',
                    value: conversionId
                } ]
            } ],
            buttons: [ {
                text: translations.convert,
                cls: 'x-btn-text',
                handler: this.convert,
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.plusmpm.EdiToPdfInvoiceConverterWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.plusmpm.EdiToPdfInvoiceConverterWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.plusmpm.EdiToPdfInvoiceConverterWindow.superclass.initComponent.call( this );
    },
    convert: function() {
        var form = this.converterPanel.getForm();

        if ( form.isValid() ) {
            form.submit();
        }
    }
} );