/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.web.rest;

import com.suncode.plugin.efaktura.service.attachment.AttachmentService;
import com.suncode.plugin.efaktura.util.AttachmentActionType;
import com.suncode.plugin.efaktura.util.AttachmentDetectionType;
import com.suncode.plugin.efaktura.web.rest.configuration.AttachmentVueDto;
import com.suncode.plugin.efaktura.web.support.dto.AttachmentDto;
import com.suncode.plugin.efaktura.web.support.dto.AttachmentEmailDto;
import com.suncode.plugin.efaktura.web.support.dto.ManagementDto;
import com.suncode.plugin.efaktura.web.support.dto.TranslationDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/attachment"})
public class AttachmentController {
    @Autowired
    private AttachmentService attachmentService;

    @RequestMapping(value={"getTranslations"}, method={RequestMethod.GET})
    @ResponseBody
    public TranslationDto getTranslations() {
        return this.attachmentService.getTranslations();
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AttachmentVueDto> getAttachments(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(defaultValue="emailFrom") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection) {
        return this.attachmentService.getAttachments(start, limit, sortBy, sortDirection);
    }

    @RequestMapping(value={"read"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AttachmentEmailDto> read(@RequestParam String fromEmails) {
        return this.attachmentService.read(fromEmails);
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseBody
    public ManagementDto create(AttachmentDto attachmentDto) {
        return this.attachmentService.create(attachmentDto);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public void createAttachment(@RequestBody AttachmentFormDto form) {
        AttachmentDto attachmentDto = new AttachmentDto();
        attachmentDto.setFromEmail(form.getEmailFrom());
        attachmentDto.setDetectionTypeValue(form.getDetectionType().getName());
        attachmentDto.setDetectionValueValue(form.getDetectionValue());
        attachmentDto.setActionTypeValue(form.getActionType().getName());
        attachmentDto.setActionValueValue(form.getActionValue());
        this.attachmentService.create(attachmentDto);
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    @ResponseBody
    public ManagementDto update(AttachmentDto attachmentDto) {
        return this.attachmentService.update(attachmentDto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void editAttachment(@PathVariable long id, @RequestBody AttachmentFormDto form) {
        AttachmentDto attachmentDto = new AttachmentDto();
        attachmentDto.setActionId(id);
        attachmentDto.setFromEmail(form.getEmailFrom());
        attachmentDto.setDetectionTypeValue(form.getDetectionType().getName());
        attachmentDto.setDetectionValueValue(form.getDetectionValue());
        attachmentDto.setActionTypeValue(form.getActionType().getName());
        attachmentDto.setActionValueValue(form.getActionValue());
        this.attachmentService.update(attachmentDto);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ManagementDto delete(AttachmentDto attachmentDto) {
        return this.attachmentService.remove(attachmentDto.getActionId());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable long id) {
        this.attachmentService.remove(id);
    }

    public static class AttachmentFormDto {
        private String emailFrom;
        private AttachmentDetectionType detectionType;
        private String detectionValue;
        private AttachmentActionType actionType;
        private String actionValue;

        public String getEmailFrom() {
            return this.emailFrom;
        }

        public AttachmentDetectionType getDetectionType() {
            return this.detectionType;
        }

        public String getDetectionValue() {
            return this.detectionValue;
        }

        public AttachmentActionType getActionType() {
            return this.actionType;
        }

        public String getActionValue() {
            return this.actionValue;
        }

        public void setEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
        }

        public void setDetectionType(AttachmentDetectionType detectionType) {
            this.detectionType = detectionType;
        }

        public void setDetectionValue(String detectionValue) {
            this.detectionValue = detectionValue;
        }

        public void setActionType(AttachmentActionType actionType) {
            this.actionType = actionType;
        }

        public void setActionValue(String actionValue) {
            this.actionValue = actionValue;
        }

        public AttachmentFormDto() {
        }

        public AttachmentFormDto(String emailFrom, AttachmentDetectionType detectionType, String detectionValue, AttachmentActionType actionType, String actionValue) {
            this.emailFrom = emailFrom;
            this.detectionType = detectionType;
            this.detectionValue = detectionValue;
            this.actionType = actionType;
            this.actionValue = actionValue;
        }
    }
}

