/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import com.suncode.plugin.efaktura.module.ExternalClassRegistry;
import com.suncode.plugin.efaktura.util.AdditionalOptions;
import jakarta.mail.Message;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InterfaceExecutor {
    public static Logger log = Logger.getLogger(InterfaceExecutor.class);
    private static String ANALYZE_MAIL_CONTENT_METHOD_NAME = "analyzeMailContent";
    private static String SET_MORE_INDEXES_FOR_FILE_METHOD_NAME = "setMoreIndexesForFile";
    private static String SHOULD_PROCESS_METHOD_NAME = "shouldProcess";
    private static String SET_INDEXES_METHOD_NAME = "setIndexes";

    public String executeAnalyzeMailContent(Message message, Set<String> indexes, File file, AdditionalOptions additionalOptions) {
        String continueAdding = "true";
        String className = additionalOptions.getClassNameWithPackage();
        if (this.shouldExecuteInterface(className)) {
            try {
                log.info((Object)("Wywolanie funkcji " + ANALYZE_MAIL_CONTENT_METHOD_NAME + " z klasy " + className));
                Object[] oMethodArgs = this.buildPlusEFakturaInterfaceMethodArgumentValues(message, indexes, file);
                Class<?>[] cMethodArgs = this.buildPlusEFakturaInterfaceMethodArgumentTypes();
                continueAdding = this.executeClassMethod(className, ANALYZE_MAIL_CONTENT_METHOD_NAME, oMethodArgs, cMethodArgs).toString();
            }
            catch (Exception e) {
                log.warn((Object)("Blad w definicji klasy, metody lub brak definicji dla metody akceptacji " + ANALYZE_MAIL_CONTENT_METHOD_NAME + ". Dodawanie dokumentu bedzie kontynuowane"));
            }
        }
        return continueAdding;
    }

    public Set<String> executeSetMoreIndexesForFile(Message message, Set<String> indexes, File file, AdditionalOptions additionalOptions) {
        String className = additionalOptions.getClassNameWithPackage();
        if (this.shouldExecuteInterface(className)) {
            try {
                log.info((Object)("Wywolanie funkcji " + SET_MORE_INDEXES_FOR_FILE_METHOD_NAME + " z klasy " + className));
                HashSet<String> finalIndexes = new HashSet<String>();
                Object[] oMethodArgs = this.buildPlusEFakturaInterfaceMethodArgumentValues(message, indexes, file);
                Class<?>[] cMethodArgs = this.buildPlusEFakturaInterfaceMethodArgumentTypes();
                Set help = (Set)this.executeClassMethod(className, SET_MORE_INDEXES_FOR_FILE_METHOD_NAME, oMethodArgs, cMethodArgs);
                if (help != null) {
                    log.info((Object)("Dolaczenie dodatkowych mapowan indeksow z zewnetrznej klasy " + className));
                    finalIndexes.addAll(help);
                }
                return finalIndexes;
            }
            catch (Exception e) {
                log.warn((Object)("Blad w definicji klasy, metody lub brak definicji dla funkcji dodatkowego mapowania indeksow " + SET_MORE_INDEXES_FOR_FILE_METHOD_NAME + ". Brak nowych mapowan indeksow"));
                return indexes;
            }
        }
        return indexes;
    }

    public boolean executeShouldProcessNonInvoiceAttachment(Message message, File file, AdditionalOptions additionalOptions) {
        boolean shouldProcess = true;
        String className = additionalOptions.getNonInvoiceAttachmentProcessorClass();
        if (this.shouldExecuteInterface(className)) {
            try {
                log.info((Object)("Wywolanie funkcji " + SHOULD_PROCESS_METHOD_NAME + " z klasy " + className));
                Object[] oMethodArgs = this.buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentValues(message, file, additionalOptions);
                Class<?>[] cMethodArgs = this.buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentTypes();
                shouldProcess = (Boolean)this.executeClassMethod(className, SHOULD_PROCESS_METHOD_NAME, oMethodArgs, cMethodArgs);
            }
            catch (Exception e) {
                log.warn((Object)("Blad w definicji klasy, metody lub brak definicji dla metody akceptacji " + SHOULD_PROCESS_METHOD_NAME + ". Dodawanie dokumentu bedzie kontynuowane"));
            }
        }
        return shouldProcess;
    }

    public Set<String> executeSetIndexesForNonInvoiceAttachment(Message message, File file, AdditionalOptions additionalOptions) {
        HashSet<String> indexes = new HashSet<String>();
        String className = additionalOptions.getNonInvoiceAttachmentProcessorClass();
        if (this.shouldExecuteInterface(className)) {
            try {
                log.info((Object)("Wywolanie funkcji " + SET_INDEXES_METHOD_NAME + " z klasy " + className));
                Object[] oMethodArgs = this.buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentValues(message, file, additionalOptions);
                Class<?>[] cMethodArgs = this.buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentTypes();
                Set help = (Set)this.executeClassMethod(className, SET_INDEXES_METHOD_NAME, oMethodArgs, cMethodArgs);
                if (help != null) {
                    log.info((Object)("Dolaczenie dodatkowych mapowan indeksow z zewnetrznej klasy " + className));
                    indexes.addAll(help);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Blad w definicji klasy, metody lub brak definicji dla funkcji dodatkowego mapowania indeksow " + SET_INDEXES_METHOD_NAME + ". Brak nowych mapowan indeksow"));
            }
        }
        return indexes;
    }

    private boolean shouldExecuteInterface(String className) {
        return StringUtils.isNotBlank((CharSequence)className) && !StringUtils.equals((CharSequence)className, (CharSequence)"NULL");
    }

    private Object[] buildPlusEFakturaInterfaceMethodArgumentValues(Message message, Set<String> indexes, File file) {
        Object[] values = new Object[]{message, indexes, file};
        return values;
    }

    private Class<?>[] buildPlusEFakturaInterfaceMethodArgumentTypes() {
        Class[] types = new Class[]{Message.class, Set.class, File.class};
        return types;
    }

    private Object[] buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentValues(Message message, File file, AdditionalOptions additionalOptions) {
        Object[] values = new Object[]{message, file, additionalOptions.getCurrentMessageId(), additionalOptions.isLastAttachmentInMail()};
        return values;
    }

    private Class<?>[] buildNonInvoiceAttachmentProcessorInterfaceMethodArgumentTypes() {
        Class[] types = new Class[]{Message.class, File.class, String.class, Boolean.class};
        return types;
    }

    private Object executeClassMethod(String className, String methodName, Object[] arguments, Class<?>[] argumentTypes) throws Exception {
        Class<?> clazz = ExternalClassRegistry.get(className);
        Method method = clazz.getMethod(methodName, argumentTypes);
        Object object = clazz.newInstance();
        return method.invoke(object, arguments);
    }
}

