/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.util;

import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.lang3.StringUtils;

public class ForwardConfig {
    private static final String SECTION_NAME = "ForwardConfiguration";
    private String auth;
    private String host;
    private String outgoingPort;
    private String password;
    private String username;
    private String startTls;
    private String ssl;
    private String debugOutput;
    private String oAuth;

    public ForwardConfig(INIConfiguration configFile, String username, String password, String host, String outgoingPort, String auth, String startTls, String ssl, String debugOutput, String oAuth) {
        this.username = this.setConfig(configFile, "Email", username);
        this.password = this.setConfig(configFile, "Password", password);
        this.host = this.setConfig(configFile, "EmailServer", host);
        this.outgoingPort = this.setConfig(configFile, "OutgoingPort", outgoingPort);
        this.auth = this.setConfig(configFile, "Authentication", auth);
        this.startTls = this.setConfig(configFile, "StartTLS", startTls);
        this.ssl = this.setConfig(configFile, "SSL", ssl);
        this.debugOutput = this.setConfig(configFile, "DebugOutput", debugOutput);
        this.oAuth = this.setConfig(configFile, "OAuth", oAuth);
    }

    public String getAuth() {
        return this.auth;
    }

    public String getHost() {
        return this.host;
    }

    public String getOutgoingPort() {
        return this.outgoingPort;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getStartTls() {
        return this.startTls;
    }

    public String getSsl() {
        return this.ssl;
    }

    public String getDebugOutput() {
        return this.debugOutput;
    }

    public String getOAuth() {
        return this.oAuth;
    }

    private String setConfig(INIConfiguration configFile, String propertyName, String defaultValue) {
        String configValue = configFile.getSection(SECTION_NAME).getString(propertyName);
        if (StringUtils.isBlank((CharSequence)configValue)) {
            return defaultValue;
        }
        return configValue;
    }
}

