/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.efaktura.docxtopdf;

import com.suncode.plugin.efaktura.docxtopdf.DocxTemplateFixer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.collections.CollectionUtils;
import org.docx4j.TraversalUtil;
import org.docx4j.model.datastorage.migration.VariablePrepare;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ProofErr;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.springframework.stereotype.Component;

@Component
public class VariablesPreparator {
    private static final String PROOF_ERR_X_PATH = "//w:proofErr";
    private static final String BOOKMARK_START_X_PATH = "//w:bookmarkStart";
    private static final String BOOKMARK_END_X_PATH = "//w:bookmarkEnd";

    public <T> void prepare(JaxbXmlPartXPathAware<T> element) {
        TraversalUtil.visit(element, (TraversalUtil.Callback)new DocxTemplateFixer());
        this.removeProofErr(element);
        this.removeBookmarkStart(element);
        this.removeBookmarkEnd(element);
        this.walkElementsByParagraph(element);
    }

    private <T> void removeProofErr(JaxbXmlPartXPathAware<T> element) {
        List<Object> nodes = this.getNodes(element, PROOF_ERR_X_PATH);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Object node : nodes) {
                if (!(node instanceof ProofErr)) continue;
                ProofErr proofErr = (ProofErr)node;
                this.removeItselfFromParent((Child)proofErr);
            }
        }
    }

    private <T> void removeBookmarkStart(JaxbXmlPartXPathAware<T> element) {
        List<Object> nodes = this.getNodes(element, BOOKMARK_START_X_PATH);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Object node : nodes) {
                if (!this.isBookmarkStartElement(node)) continue;
                CTBookmark bookmark = this.getBookmarkStartElement(node);
                Object parent = bookmark.getParent();
                this.removeChildFromParent(parent, node);
            }
        }
    }

    private boolean isBookmarkStartElement(Object element) {
        return element instanceof JAXBElement && ((JAXBElement)element).getValue() instanceof CTBookmark;
    }

    private CTBookmark getBookmarkStartElement(Object node) {
        JAXBElement jaxbElement = (JAXBElement)node;
        return (CTBookmark)jaxbElement.getValue();
    }

    private <T> void removeBookmarkEnd(JaxbXmlPartXPathAware<T> element) {
        List<Object> nodes = this.getNodes(element, BOOKMARK_END_X_PATH);
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Object node : nodes) {
                if (!this.isBookmarkEndElement(node)) continue;
                CTMarkupRange bookmark = this.getBookmarkEndElement(node);
                Object parent = bookmark.getParent();
                this.removeChildFromParent(parent, node);
            }
        }
    }

    private boolean isBookmarkEndElement(Object element) {
        return element instanceof JAXBElement && ((JAXBElement)element).getValue() instanceof CTMarkupRange;
    }

    private CTMarkupRange getBookmarkEndElement(Object node) {
        JAXBElement jaxbElement = (JAXBElement)node;
        return (CTMarkupRange)jaxbElement.getValue();
    }

    private <T> List<Object> getNodes(JaxbXmlPartXPathAware<T> element, String xPath) {
        try {
            return element.getJAXBNodesViaXPath(xPath, false);
        }
        catch (Exception exception) {
            return new ArrayList<Object>();
        }
    }

    private boolean removeItselfFromParent(Child child) {
        Object parent = child.getParent();
        return this.removeChildFromParent(parent, child);
    }

    private boolean removeChildFromParent(Object parent, Object child) {
        if (parent instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            return contentAccessor.getContent().remove(child);
        }
        return false;
    }

    private <T> void walkElementsByParagraph(JaxbXmlPartXPathAware<T> element) {
        SingleTraversalUtilVisitorCallback paragraphVisitor = new SingleTraversalUtilVisitorCallback((TraversalUtilVisitor)new VariablePrepare.TraversalUtilParagraphVisitor());
        paragraphVisitor.walkJAXBElements(element);
    }
}

