function IEWorkarounds() {
    if ( !Ext.isFunction( document.createElementNS ) ) {
        document.createElementNS = function( uri, name ) {
            return document.createElement( name );
        };
    }

    if ( typeof Range !== 'undefined' && !Range.prototype.createContextualFragment ) {
        Range.prototype.createContextualFragment = function( html ) {
            var frag = document.createDocumentFragment(), div = document.createElement( 'div' );
            frag.appendChild( div );
            div.outerHTML = html;
            return frag;
        };
    }
}

function initQuickTips() {
    Ext.QuickTips.init();
}

function ExtOverrides() {
    Ext.override( Ext.layout.ContainerLayout, {
        fieldTpl: new Ext.Template( '<div class="x-form-item {itemCls}" tabIndex="-1">', '<label '
                        + 'style="{labelStyle}" class="x-form-item-label">{label}{labelSeparator}</label>',
                        '<div class="x-form-element" id="x-form-el-{id}" style="{elementStyle}">', '</div><div class="{clearCls}"></div>', '</div>',
                        {
                            disableFormats: true,
                            compiled: true
                        } )
    } );

    Ext.override( Ext.form.ComboBox, {
        beforeBlur: function() {
            var val = this.getRawValue(), rec;
            if ( this.valueField && Ext.isDefined( this.value ) ) {
                rec = this.findRecord( this.valueField, this.value );
                if ( rec && rec.get( this.displayField ) == val ) {
                    return;
                }
            }
            rec = this.findRecord( this.displayField, val );
            if ( !rec && this.forceSelection ) {
                if ( val.length > 0 && val != this.emptyText ) {
                    this.el.dom.value = Ext.isDefined( this.lastSelectionText ) ? this.lastSelectionText : '';
                    this.applyEmptyText();
                } else {
                    this.clearValue();
                }
            } else {
                if ( rec ) {
                    val = rec.get( this.valueField || this.displayField );
                }
                this.setValue( val );
            }
        }
    } );
}

Ext.util.Format.ComboBoxRenderer = function( combo ) {
    return function( value ) {
        var record = combo.findRecord( combo.valueField, value );
        var wrongValue = '';

        if ( !Ext.isEmpty( value ) ) {
            wrongValue = '###';
        }

        if ( combo.forceSelection ) {
            return record ? record.get( combo.displayField ) : wrongValue;
        } else {
            return record ? record.get( combo.displayField ) : value;
        }
    };
};

function showWarn( msg ) {
    var warnDialog = Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.Msg.WARNING
    } ).getDialog();
    warnDialog.toFront();
    closeDialogOnMaskClick( warnDialog );
}

function closeDialogOnMaskClick( dialog ) {
    var mask = Ext.get( dialog.mask.id );
    mask.on( 'click', function( e ) {
        var button = dialog.buttons[0];

        if ( button ) {
            button.handler.call( button );
        }
    } );
}

function removeRowAndMarkNext( grid, row ) {
    var store = grid.getStore();
    var idx = store.indexOf( row );
    store.remove( row );
    store.commitChanges();
    var storeCount = store.getCount();

    if ( storeCount > 0 ) {
        if ( storeCount <= idx ) {
            idx--;
        }

        grid.getSelectionModel().selectRow( idx );
    }
}