Ext.ux.suncode.I18N = {
    language: 'pl',
    bundle: new Array(),
    init: function( language ) {
        this.language = language;

        this.populateBundle();
    },
    populateBundle: function() {
        var language = this.language;
        var translationMap = this.bundle;

        switch( language ) {
        	case 'pl':
        		break;
        	case 'de':
                translationMap['Uprawnienia'] = 'Berechtigungen';
                translationMap['Filtry'] = 'Filter';
                translationMap['Wyczyść filtry'] = 'Filter löschen';
                translationMap['Wartość uprawnienia'] = 'Berechtigungswert';
                translationMap['Zakres uprawnienia'] = 'Berechtigungsumfang';
                translationMap['Użytkownik'] = 'Benutzer';
                translationMap['Grupa'] = 'Gruppe';
                translationMap['Trwa ładowanie danych...'] = 'Datenbeladung im Gange ...';
                translationMap['Brak uprawnień'] = 'Keine Berechtigungen';
                translationMap['Dodaj uprawnienie'] = 'Berechtigung hinzufügen';
                translationMap['Uprawnienie już istnieje.'] = 'Erlaubnis existiert bereits.';
                translationMap['Usuń uprawnienie'] = 'Erlaubnis entfernen';
                translationMap['Wybierz uprawnienie do usunięcia.'] = 'Wählen Sie die Berechtigung zum Entfernen.';
                translationMap['Uprawnienie nie istnieje.'] = 'Erlaubnis existiert nicht.'
                translationMap['Wystąpił błąd.'] = 'Ein Fehler ist aufgetreten.';
                translationMap['Dodawanie uprawnienia'] = 'Berechtigungszusatz';
                translationMap['Zapisz'] = 'Sparen';
                translationMap['Zamknij'] = 'Schließen';
                translationMap['Pole jest wymagane'] = 'Feld ist erforderlich';
                translationMap['Login'] = 'Anmeldung';
                translationMap['Imię'] = 'Vorname';
                translationMap['Nazwisko'] = 'Familienname, Nachname';
                translationMap['Nazwa'] = 'Name';
                translationMap['Opis'] = 'Beschreibung';
                translationMap['Uwaga'] = 'Warnung';
                translationMap['Kolumny'] = 'Spalten';
                translationMap['Sortuj rosnąco'] =  'Aufsteigend sortieren';
                translationMap['Sortuj malejąco'] ='Absteigend sortieren';
                translationMap['Pierwsza strona'] = 'Erste Seite';
                translationMap['Poprzednia strona'] = 'Vorherige Seite';
                translationMap['Następna strona'] = 'Folgeseite';
                translationMap['Ostatnia strona'] = 'Letzte Seite';
                translationMap['Odśwież'] = 'Refresh';
                translationMap['Strona'] = 'Seite';
                translationMap['z'] = 'von';
        		break;
        	default:
                translationMap['Uprawnienia'] = 'Permissions';
                translationMap['Filtry'] = 'Filters';
                translationMap['Wyczyść filtry'] = 'Clear filters';
                translationMap['Wartość uprawnienia'] = 'Permission value';
                translationMap['Zakres uprawnienia'] = 'Permission scope';
                translationMap['Użytkownik'] = 'User';
                translationMap['Grupa'] = 'Group';
                translationMap['Trwa ładowanie danych...'] = 'Data loading in progress...';
                translationMap['Brak uprawnień'] = 'No permissions';
                translationMap['Dodaj uprawnienie'] = 'Add permission';
                translationMap['Uprawnienie już istnieje.'] = 'Permission already exists.';
                translationMap['Usuń uprawnienie'] = 'Remove permission';
                translationMap['Wybierz uprawnienie do usunięcia.'] = 'Choose permission to remove.';
                translationMap['Uprawnienie nie istnieje.'] = 'Permission does not exist.';
                translationMap['Wystąpił błąd.'] = 'Error occurred.';
                translationMap['Dodawanie uprawnienia'] = 'Permission addition';
                translationMap['Zapisz'] = 'Save';
                translationMap['Zamknij'] = 'Close';
                translationMap['Pole jest wymagane'] = 'Field is required';
                translationMap['Login'] = 'Login';
                translationMap['Imię'] = 'First name';
                translationMap['Nazwisko'] = 'Last name';
                translationMap['Nazwa'] = 'Name';
                translationMap['Opis'] = 'Description';
                translationMap['Uwaga'] = 'Warning';
                translationMap['Kolumny'] = 'Columns';
                translationMap['Sortuj rosnąco'] = 'Sort ascending';
                translationMap['Sortuj malejąco'] = 'Sort descending';
                translationMap['Pierwsza strona'] = 'First page';
                translationMap['Poprzednia strona'] = 'Previous page';
                translationMap['Następna strona'] = 'Next page';
                translationMap['Ostatnia strona'] = 'Last page';
                translationMap['Odśwież'] = 'Refresh';
                translationMap['Strona'] = 'Page';
                translationMap['z'] = 'from';
        		break;
        }
    },
    getLanguage: function() {
        return this.language;
    },
    getMessage: function( key ) {
        var message = this.bundle[key];

        return !Ext.isEmpty( message ) ? message : key;
    }
};

function getTranslation( key ) {
    return Ext.ux.suncode.I18N.getMessage( key );
}